/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.cache;

import cool.scx.common.cache.FixedSizeLinkedHashMap;
import cool.scx.common.cache.ICache;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class Cache<K, V>
implements ICache<K, V> {
    private final Map<K, V> map;

    public Cache(int maxSize) {
        this(maxSize, false);
    }

    public Cache(int maxSize, boolean useSynchronized) {
        this(maxSize, useSynchronized, false);
    }

    public Cache(int maxSize, boolean useSynchronized, boolean accessOrder) {
        this.map = useSynchronized ? Collections.synchronizedMap(new FixedSizeLinkedHashMap(maxSize, 16, 0.75f, accessOrder)) : new FixedSizeLinkedHashMap(maxSize, 16, 0.75f, accessOrder);
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key, mappingFunction);
    }
}

