/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import cool.scx.common.jackson.BuildOptions;
import cool.scx.common.jackson.JacksonHelper;
import cool.scx.common.util.StringUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ObjectUtils {
    public static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final JsonMapper JSON_MAPPER;
    private static final XmlMapper XML_MAPPER;
    private static final Map<BuildOptions, JsonMapper> JSON_MAPPER_CACHE;
    private static final Map<BuildOptions, XmlMapper> XML_MAPPER_CACHE;

    public static JsonMapper jsonMapper(Options options) {
        return JSON_MAPPER_CACHE.computeIfAbsent(options.toBuildOptions(), k -> (JsonMapper)JacksonHelper.createObjectMapper(JsonMapper.builder(), k));
    }

    public static XmlMapper xmlMapper(Options options) {
        return XML_MAPPER_CACHE.computeIfAbsent(options.toBuildOptions(), k -> (XmlMapper)JacksonHelper.createObjectMapper(XmlMapper.builder(), k));
    }

    public static JsonMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static XmlMapper xmlMapper() {
        return XML_MAPPER;
    }

    public static JavaType constructType(Type type) {
        return ObjectUtils.getTypeFactory().constructType(type);
    }

    public static JavaType constructType(TypeReference<?> typeRef) {
        return ObjectUtils.getTypeFactory().constructType(typeRef);
    }

    public static JavaType resolveMemberType(Type type, TypeBindings contextBindings) {
        return ObjectUtils.getTypeFactory().resolveMemberType(type, contextBindings);
    }

    public static TypeFactory getTypeFactory() {
        return ObjectUtils.jsonMapper().getTypeFactory();
    }

    public static <T> T convertValue(Object fromValue, JavaType javaType, Options options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, javaType);
    }

    public static <T> T convertValue(Object fromValue, Class<T> tClass, Options options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(tClass));
    }

    public static <T> T convertValue(Object fromValue, Type toValueType, Options options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(toValueType));
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef, Options options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(toValueTypeRef));
    }

    public static <T> T convertValue(Object fromValue, JavaType javaType) {
        return (T)ObjectUtils.jsonMapper().convertValue(fromValue, javaType);
    }

    public static <T> T convertValue(Object fromValue, Class<T> tClass) {
        return (T)ObjectUtils.jsonMapper().convertValue(fromValue, ObjectUtils.constructType(tClass));
    }

    public static <T> T convertValue(Object fromValue, Type toValueType) {
        return (T)ObjectUtils.jsonMapper().convertValue(fromValue, ObjectUtils.constructType(toValueType));
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)ObjectUtils.jsonMapper().convertValue(fromValue, ObjectUtils.constructType(toValueTypeRef));
    }

    public static String toJson(Object value, String defaultValue, Options options) {
        try {
            return ObjectUtils.toJson(value, options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toXml(Object value, String defaultValue, Options options) {
        try {
            return ObjectUtils.toXml(value, options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toJson(Object value, String defaultValue) {
        try {
            return ObjectUtils.toJson(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toXml(Object value, String defaultValue) {
        try {
            return ObjectUtils.toXml(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toJson(Object value, Options options) throws JsonProcessingException {
        return ObjectUtils.jsonMapper(options).writeValueAsString(value);
    }

    public static String toXml(Object value, Options options) throws JsonProcessingException {
        return ObjectUtils.xmlMapper(options).writeValueAsString(value);
    }

    public static String toJson(Object value) throws JsonProcessingException {
        return ObjectUtils.jsonMapper().writeValueAsString(value);
    }

    public static String toXml(Object value) throws JsonProcessingException {
        return ObjectUtils.xmlMapper().writeValueAsString(value);
    }

    private static Map<String, Object> flatMap0(Map<?, ?> sourceMap, String parentKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object prefix = StringUtils.isBlank(parentKey) ? "" : parentKey + ".";
        sourceMap.forEach((arg_0, arg_1) -> ObjectUtils.lambda$flatMap0$0((String)prefix, result, arg_0, arg_1));
        return result;
    }

    public static Map<String, Object> flatMap(Map<?, ?> sourceMap) {
        return ObjectUtils.flatMap0(sourceMap, null);
    }

    private static /* synthetic */ void lambda$flatMap0$0(String prefix, LinkedHashMap result, Object key, Object value) {
        String newKey = prefix + String.valueOf(key);
        if (value instanceof Map) {
            Map m = (Map)value;
            result.putAll(ObjectUtils.flatMap0(m, newKey));
        } else {
            result.put(newKey, value);
        }
    }

    static {
        JSON_MAPPER_CACHE = new HashMap<BuildOptions, JsonMapper>();
        XML_MAPPER_CACHE = new HashMap<BuildOptions, XmlMapper>();
        JSON_MAPPER = ObjectUtils.jsonMapper(new Options());
        XML_MAPPER = ObjectUtils.xmlMapper(new Options());
    }

    public static class Options {
        boolean ignoreNullValue = false;
        boolean ignoreJsonIgnore = false;
        boolean failOnUnknownProperties = false;
        boolean failOnEmptyBeans = false;
        Map<PropertyAccessor, JsonAutoDetect.Visibility> visibilityConfig = null;

        public Options setIgnoreNullValue(boolean ignoreNullValue) {
            this.ignoreNullValue = ignoreNullValue;
            return this;
        }

        public Options setIgnoreJsonIgnore(boolean ignoreJsonIgnore) {
            this.ignoreJsonIgnore = ignoreJsonIgnore;
            return this;
        }

        public Options setFailOnUnknownProperties(boolean failOnUnknownProperties) {
            this.failOnUnknownProperties = failOnUnknownProperties;
            return this;
        }

        public Options setFailOnEmptyBeans(boolean failOnEmptyBeans) {
            this.failOnEmptyBeans = failOnEmptyBeans;
            return this;
        }

        public Options visibility(PropertyAccessor a, JsonAutoDetect.Visibility b) {
            if (this.visibilityConfig == null) {
                this.visibilityConfig = new HashMap<PropertyAccessor, JsonAutoDetect.Visibility>();
            }
            this.visibilityConfig.put(a, b);
            return this;
        }

        BuildOptions toBuildOptions() {
            return new BuildOptions(this.ignoreNullValue, this.ignoreJsonIgnore, false, false, this.visibilityConfig);
        }
    }
}

