/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.multi_map;

import cool.scx.common.multi_map.IMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class MultiMap<K, V>
implements IMultiMap<K, V> {
    private final Map<K, List<V>> map;
    private final Supplier<List<V>> listSupplier;

    public MultiMap(Supplier<Map<K, List<V>>> mapSupplier, Supplier<List<V>> listSupplier) {
        this.map = mapSupplier.get();
        this.listSupplier = listSupplier;
    }

    public MultiMap() {
        this(HashMap::new, ArrayList::new);
    }

    @Override
    public boolean add(K key, V value) {
        List v = this.map.computeIfAbsent(key, k -> this.listSupplier.get());
        return v.add(value);
    }

    @Override
    public boolean add(K key, V ... values) {
        List v = this.map.computeIfAbsent(key, k -> this.listSupplier.get());
        return Collections.addAll(v, values);
    }

    @Override
    public boolean add(K key, Collection<? extends V> values) {
        List v = this.map.computeIfAbsent(key, k -> this.listSupplier.get());
        return v.addAll(values);
    }

    @Override
    public void add(Map<? extends K, ? extends V> map) {
        map.forEach(this::add);
    }

    @Override
    public void add(IMultiMap<? extends K, ? extends V> map) {
        for (Map.Entry entry : map) {
            this.add(entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public List<V> set(K key, V value) {
        List<V> v = this.listSupplier.get();
        v.add(value);
        return this.map.put(key, v);
    }

    @Override
    public List<V> set(K key, V ... values) {
        List<V> v = this.listSupplier.get();
        Collections.addAll(v, values);
        return this.map.put(key, v);
    }

    @Override
    public List<V> set(K key, Collection<? extends V> values) {
        List<V> v = this.listSupplier.get();
        v.addAll(values);
        return this.map.put(key, v);
    }

    @Override
    public void set(Map<? extends K, ? extends V> map) {
        map.forEach(this::set);
    }

    @Override
    public void set(IMultiMap<? extends K, ? extends V> map) {
        for (Map.Entry entry : map) {
            this.set(entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public V get(K key) {
        List<V> values = this.map.get(key);
        return values == null || values.size() == 0 ? null : (V)values.get(0);
    }

    @Override
    public List<V> getAll(K key) {
        return this.map.getOrDefault(key, this.listSupplier.get());
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        for (List<V> values : this.map.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(K key, V value) {
        List<V> v = this.map.get(key);
        if (v == null) {
            return false;
        }
        boolean remove = v.remove(value);
        if (v.isEmpty()) {
            this.map.remove(key);
        }
        return remove;
    }

    @Override
    public boolean remove(K key, V ... values) {
        List<V> v = this.map.get(key);
        if (v == null) {
            return false;
        }
        boolean anyRemoved = false;
        for (V value : values) {
            anyRemoved |= v.remove(value);
        }
        if (v.isEmpty()) {
            this.map.remove(key);
        }
        return anyRemoved;
    }

    @Override
    public boolean remove(K key, Collection<? extends V> values) {
        List<V> v = this.map.get(key);
        if (v == null) {
            return false;
        }
        boolean remove = v.removeAll(values);
        if (v.isEmpty()) {
            this.map.remove(key);
        }
        return remove;
    }

    @Override
    public List<V> removeAll(K key) {
        return this.map.remove(key);
    }

    @Override
    public Set<K> keys() {
        return this.map.keySet();
    }

    @Override
    public List<V> values() {
        List<V> list = this.listSupplier.get();
        for (List<V> v : this.map.values()) {
            list.addAll(v);
        }
        return list;
    }

    @Override
    public long size() {
        long size = 0L;
        for (List<V> value : this.map.values()) {
            size += (long)value.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public void clear() {
        for (List<V> value : this.map.values()) {
            value.clear();
        }
        this.map.clear();
    }

    @Override
    public Map<K, List<V>> toMultiValueMap() {
        return this.map;
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        return this.toSingleValueMap(HashMap::new);
    }

    @Override
    public Map<K, V> toSingleValueMap(Supplier<Map<K, V>> mapSupplier) {
        Map<K, V> tempMap = mapSupplier.get();
        for (Map.Entry<K, List<V>> e : this.map.entrySet()) {
            K key = e.getKey();
            List<V> value = e.getValue();
            if (value == null || value.isEmpty()) continue;
            tempMap.put(key, value.get(0));
        }
        return tempMap;
    }

    @Override
    public void forEach(BiConsumer<? super K, V> action) {
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> values = entry.getValue();
            for (V value : values) {
                action.accept(key, value);
            }
        }
    }

    @Override
    public Iterator<Map.Entry<K, List<V>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.map.toString();
    }
}

