/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.huffman;

import cool.scx.collections.bit_array.BitArray;
import cool.scx.collections.bit_array.IBitArray;
import cool.scx.collections.count_map.CountMap;
import cool.scx.collections.count_map.ICountMap;
import cool.scx.common.huffman.HuffmanNode;
import cool.scx.common.util.$;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class HuffmanHelper {
    public static <T> CountMap<T> buildCountMap(T[] data) {
        return $.countingBy(data);
    }

    public static <T> PriorityQueue<HuffmanNode<T>> buildPriorityQueue(ICountMap<T> map) {
        PriorityQueue<HuffmanNode<T>> queue = new PriorityQueue<HuffmanNode<T>>(Comparator.comparingInt(a -> a.frequency));
        for (Map.Entry entry : map) {
            queue.offer(new HuffmanNode(entry.getKey(), ((Long)entry.getValue()).intValue()));
        }
        return queue;
    }

    public static <T> HuffmanNode<T> buildHuffmanTree(PriorityQueue<HuffmanNode<T>> queue) {
        while (queue.size() > 1) {
            HuffmanNode<T> left = queue.poll();
            HuffmanNode<T> right = queue.poll();
            HuffmanNode<T> parent = new HuffmanNode<T>(left.frequency + right.frequency, left, right);
            queue.add(parent);
        }
        return queue.poll();
    }

    public static <T> Map<T, IBitArray> normalHuffmanCode(Map<T, String> huffmanCode) {
        HashMap<T, BitArray> map = new HashMap<T, BitArray>();
        for (Map.Entry<T, String> e : huffmanCode.entrySet()) {
            map.put(e.getKey(), new BitArray(e.getValue()));
        }
        return map;
    }

    public static <T> Map<T, IBitArray> buildHuffmanCodeTable(HuffmanNode<T> root) {
        HashMap huffmanCode = new HashMap();
        HuffmanHelper.buildHuffmanCodeTable0(root, (IBitArray)new BitArray(), huffmanCode);
        return huffmanCode;
    }

    private static <T> void buildHuffmanCodeTable0(HuffmanNode<T> node, IBitArray path, Map<T, IBitArray> huffmanCode) {
        if (node.isLeaf()) {
            huffmanCode.put(node.value, path);
        } else {
            if (node.left != null) {
                BitArray leftPath = new BitArray();
                leftPath.append(path);
                leftPath.append(false);
                HuffmanHelper.buildHuffmanCodeTable0(node.left, (IBitArray)leftPath, huffmanCode);
            }
            if (node.right != null) {
                BitArray rightPath = new BitArray();
                rightPath.append(path);
                rightPath.append(true);
                HuffmanHelper.buildHuffmanCodeTable0(node.right, (IBitArray)rightPath, huffmanCode);
            }
        }
    }

    public static <T> HuffmanNode<T> buildHuffmanTreeFromCode(Map<T, IBitArray> huffmanCode) {
        HuffmanNode<Object> root = new HuffmanNode<Object>(null, 0);
        for (Map.Entry<T, IBitArray> entry : huffmanCode.entrySet()) {
            T symbol = entry.getKey();
            IBitArray codePath = entry.getValue();
            HuffmanNode<Object> current = root;
            for (int i = 0; i < codePath.length(); ++i) {
                if (codePath.get(i)) {
                    if (current.right == null) {
                        current.right = new HuffmanNode<Object>(null, 0);
                    }
                    current = current.right;
                    continue;
                }
                if (current.left == null) {
                    current.left = new HuffmanNode<Object>(null, 0);
                }
                current = current.left;
            }
            current.value = symbol;
        }
        return root;
    }

    public static void buildTreeString(HuffmanNode<?> node, StringBuilder sb, String prefix) {
        if (node != null) {
            if (node.isLeaf()) {
                sb.append(prefix).append("\u2514\u2500\u2500 ").append(node.value).append("\n");
            } else {
                sb.append(prefix).append("\u2514\u2500\u2500 *\n");
                String newPrefix = prefix + "    ";
                HuffmanHelper.buildTreeString(node.left, sb, newPrefix);
                HuffmanHelper.buildTreeString(node.right, sb, newPrefix);
            }
        }
    }
}

