/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.functional.ScxCallable;
import cool.scx.functional.ScxRunnable;
import cool.scx.functional.ScxSupplier;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ScopedValue<T> {
    private static final AtomicLong THREAD_NUMBER = new AtomicLong(0L);
    private final InheritableThreadLocal<T> threadLocal = new InheritableThreadLocal();

    public static <T> ScopedValue<T> newInstance() {
        return new ScopedValue<T>();
    }

    public static <T> Carrier<T> where(ScopedValue<T> key, T value) {
        return new Carrier<T>(key, value);
    }

    void bind(T value) {
        this.threadLocal.set(value);
    }

    public T get() {
        return this.threadLocal.get();
    }

    public static final class Carrier<T> {
        private final T value;
        private final ScopedValue<T> key;

        public Carrier(ScopedValue<T> key, T value) {
            this.key = key;
            this.value = value;
        }

        public <E extends Throwable> void run(ScxRunnable<E> op) throws E {
            AtomicReference exception = new AtomicReference();
            Thread w = Thread.ofPlatform().name("scx-scoped-value-thread-", THREAD_NUMBER.getAndIncrement()).start(() -> {
                this.key.bind(this.value);
                try {
                    op.run();
                }
                catch (Throwable e) {
                    exception.set(e);
                }
            });
            try {
                w.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            if (exception.get() != null) {
                throw (Throwable)exception.get();
            }
        }

        public <R, E extends Throwable> R get(ScxSupplier<? extends R, E> op) throws E {
            AtomicReference result = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            Thread w = Thread.ofPlatform().name("scx-scoped-value-thread-", THREAD_NUMBER.getAndIncrement()).start(() -> {
                this.key.bind(this.value);
                try {
                    Object r = op.get();
                    result.set(r);
                }
                catch (Throwable e) {
                    exception.set(e);
                }
            });
            try {
                w.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            if (exception.get() != null) {
                throw (Throwable)exception.get();
            }
            return (R)result.get();
        }

        public <R, E extends Throwable> R call(ScxCallable<? extends R, E> op) throws E {
            AtomicReference result = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            Thread w = Thread.ofPlatform().name("scx-scoped-value-thread-", THREAD_NUMBER.getAndIncrement()).start(() -> {
                this.key.bind(this.value);
                try {
                    Object r = op.call();
                    result.set(r);
                }
                catch (Throwable e) {
                    exception.set(e);
                }
            });
            try {
                w.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            if (exception.get() != null) {
                throw (Throwable)exception.get();
            }
            return (R)result.get();
        }
    }
}

