/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.exception;

import cool.scx.common.exception.ScxRuntimeException;
import cool.scx.functional.ScxRunnable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public final class ScxExceptionHelper {
    public static <T> T wrap(Callable<T> handler) {
        try {
            return handler.call();
        }
        catch (Throwable throwable) {
            throw new ScxRuntimeException(throwable);
        }
    }

    public static void wrap(ScxRunnable<?> handler) {
        try {
            handler.run();
        }
        catch (Throwable throwable) {
            throw new ScxRuntimeException(throwable);
        }
    }

    public static <T> T ignore(Callable<T> handler) {
        try {
            return handler.call();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T ignore(Callable<T> handler, T defaultVal) {
        try {
            return handler.call();
        }
        catch (Throwable throwable) {
            return defaultVal;
        }
    }

    public static void ignore(ScxRunnable<?> handler) {
        try {
            handler.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean noException(ScxRunnable<?> scxRunnable) {
        try {
            scxRunnable.run();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable instanceof ScxRuntimeException || throwable instanceof ExecutionException || throwable instanceof CompletionException) {
            return ScxExceptionHelper.getRootCause(throwable.getCause());
        }
        return throwable;
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }
}

