/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.scope_value;

import cool.scx.functional.ScxCallable;
import cool.scx.functional.ScxRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public final class ScxScopedValue<T> {
    private static final Object UNBOUND = new Object();
    private final InheritableThreadLocal<Object> threadLocal = new InheritableThreadLocal<Object>(this){

        @Override
        protected Object initialValue() {
            return UNBOUND;
        }
    };

    public static <T> ScxScopedValue<T> newInstance() {
        return new ScxScopedValue<T>();
    }

    public static <T> Carrier where(ScxScopedValue<T> key, T value) {
        return new Carrier(key, value, null);
    }

    public T get() {
        Object value = this.threadLocal.get();
        if (value == UNBOUND) {
            throw new NoSuchElementException("ScopedValue not bound");
        }
        return value;
    }

    public boolean isBound() {
        Object value = this.threadLocal.get();
        return value != UNBOUND;
    }

    public static final class Carrier {
        private final ScxScopedValue<?> key;
        private final Object value;
        private final Carrier prev;

        public Carrier(ScxScopedValue<?> key, Object value, Carrier prev) {
            this.key = key;
            this.value = value;
            this.prev = prev;
        }

        private void bindAll(List<Object> oldValues) {
            if (this.prev != null) {
                this.prev.bindAll(oldValues);
            }
            oldValues.addLast(this.key.threadLocal.get());
            this.key.threadLocal.set(this.value);
        }

        private void restoreAll(List<Object> oldValues) {
            Object old = oldValues.removeLast();
            this.key.threadLocal.set(old);
            if (this.prev != null) {
                this.prev.restoreAll(oldValues);
            }
        }

        public <T> Carrier where(ScxScopedValue<T> key, T value) {
            return new Carrier(key, value, this);
        }

        public <E extends Throwable> void run(ScxRunnable<E> op) throws E {
            ArrayList<Object> oldValues = new ArrayList<Object>();
            this.bindAll(oldValues);
            try {
                op.run();
            }
            finally {
                this.restoreAll(oldValues);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R, E extends Throwable> R call(ScxCallable<? extends R, E> op) throws E {
            ArrayList<Object> oldValues = new ArrayList<Object>();
            this.bindAll(oldValues);
            try {
                Object object = op.call();
                return (R)object;
            }
            finally {
                this.restoreAll(oldValues);
            }
        }
    }
}

