/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.tree;

import cool.scx.collections.multi_map.MultiMap;
import cool.scx.common.tree.ScxTree;
import cool.scx.common.tree.ScxTreeModel;
import cool.scx.common.tree.ScxTreeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ScxTreeHelper {
    public static <T extends ScxTree<T>> void walk(T scxTree, ScxTreeVisitor<T> visitor) {
        ScxTreeHelper._walk(null, scxTree, visitor);
    }

    private static <T extends ScxTree<T>> void _walk(List<T> parents, T currentScxTree, ScxTreeVisitor<T> visitor) {
        visitor.handle(parents, currentScxTree);
        ArrayList<T> newParents = parents == null ? new ArrayList<T>() : new ArrayList<T>(parents);
        newParents.add(currentScxTree);
        if (currentScxTree.children() != null) {
            for (ScxTree child : currentScxTree.children()) {
                ScxTreeHelper._walk(newParents, child, visitor);
            }
        }
    }

    public static <T extends ScxTreeModel<T>> List<T> listToTree(List<T> list) {
        return ScxTreeHelper.listToTree(list, false);
    }

    public static <T extends ScxTreeModel<T>> List<T> listToTree(List<T> list, boolean ignoreOrphans) {
        if (list == null) {
            throw new IllegalArgumentException("listToTree : \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        HashMap<Object, ScxTreeModel> idMap = new HashMap<Object, ScxTreeModel>(list.size());
        MultiMap parentIDMap = new MultiMap();
        for (ScxTreeModel t : list) {
            idMap.put(t.id(), t);
            parentIDMap.add(t.parentID(), (Object)t);
        }
        return list.stream().filter(my -> {
            List myChildren;
            boolean isOrphan;
            Object myID = my.id();
            Object parentID = my.parentID();
            boolean bl = isOrphan = !ignoreOrphans && (parentID == null || idMap.get(parentID) == null);
            if (myID != null && (myChildren = parentIDMap.getAll(myID)).size() > 0) {
                my.children(myChildren);
            }
            return my.isRoot() || isOrphan;
        }).toList();
    }
}

