/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.bit_array;

import cool.scx.common.bit_array.BitArray;
import cool.scx.common.bit_array.IBitArray;

public class BitArrayView
implements IBitArray {
    private final IBitArray[] bitArrays;
    private final int[] startIndices;
    private final int length;

    public BitArrayView(IBitArray ... bitArrays) {
        this.bitArrays = bitArrays;
        this.startIndices = new int[bitArrays.length];
        int length = 0;
        for (int i = 0; i < bitArrays.length; ++i) {
            this.startIndices[i] = length;
            length += bitArrays[i].length();
        }
        this.length = length;
    }

    @Override
    public void set(int index, boolean value) throws IndexOutOfBoundsException {
        this._checkIndex(index);
        this._set0(index, value);
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) throws IndexOutOfBoundsException {
        this._checkIndex(fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            this._set0(i, value);
        }
    }

    @Override
    public boolean get(int index) {
        this._checkIndex(index);
        return this._get0(index);
    }

    @Override
    public IBitArray get(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        this._checkIndex(fromIndex, toIndex);
        BitArray result = new BitArray(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.set(i - fromIndex, this._get0(i));
        }
        return result;
    }

    @Override
    public void length(int length) {
        throw new UnsupportedOperationException("\u89c6\u56fe\u4e0d\u652f\u6301\u8bbe\u7f6e length !!!");
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte[] toBytes() {
        BitArray ba = new BitArray(this.length);
        for (IBitArray bitArray : this.bitArrays) {
            ba.append(bitArray);
        }
        return ba.toBytes();
    }

    @Override
    public String toBinaryString() {
        StringBuilder sb = new StringBuilder(this.length);
        for (IBitArray bitArray : this.bitArrays) {
            sb.append(bitArray.toBinaryString());
        }
        return sb.toString();
    }

    @Override
    public void append(boolean value) {
        throw new UnsupportedOperationException("\u89c6\u56fe\u4e0d\u652f\u6301 append !!!");
    }

    @Override
    public void append(IBitArray other) {
        throw new UnsupportedOperationException("\u89c6\u56fe\u4e0d\u652f\u6301 append !!!");
    }

    private void _checkIndex(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15 " + index + " \u8d85\u51fa\u8303\u56f4, \u957f\u5ea6\u4e3a " + this.length);
        }
    }

    private void _checkIndex(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15\u8303\u56f4 (" + fromIndex + ", " + toIndex + ") \u8d85\u51fa\u8303\u56f4, \u957f\u5ea6\u4e3a " + this.length);
        }
    }

    private void _set0(int index, boolean value) {
        int arrayIndex = this._findBitArrayIndex(index);
        int relativeIndex = index - this.startIndices[arrayIndex];
        this.bitArrays[arrayIndex].set(relativeIndex, value);
    }

    private boolean _get0(int index) {
        int arrayIndex = this._findBitArrayIndex(index);
        int relativeIndex = index - this.startIndices[arrayIndex];
        return this.bitArrays[arrayIndex].get(relativeIndex);
    }

    private int _findBitArrayIndex(int index) {
        int low = 0;
        int high = this.startIndices.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (index < this.startIndices[mid]) {
                high = mid - 1;
                continue;
            }
            if (mid == this.startIndices.length - 1 || index < this.startIndices[mid + 1]) {
                return mid;
            }
            low = mid + 1;
        }
        throw new IndexOutOfBoundsException("\u7d22\u5f15\u8d85\u51fa\u8303\u56f4: " + index);
    }
}

