/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.os;

import cool.scx.common.os.OSInfo;
import cool.scx.common.os.OSType;

public final class OSHelper {
    private static final OSInfo osInfo = OSHelper.initOSInfo();

    private static OSInfo initOSInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return new OSInfo(OSHelper.getOSType(osName), osVersion);
    }

    private static OSType getOSType(String osName) {
        if (osName.startsWith("Linux")) {
            if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
                return OSType.ANDROID;
            }
            return OSType.LINUX;
        }
        if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            return OSType.MAC;
        }
        if (osName.startsWith("Windows")) {
            return OSType.WINDOWS;
        }
        return OSType.UNKNOWN;
    }

    public static OSInfo getOSInfo() {
        return osInfo;
    }

    public static boolean isMac() {
        return osInfo.type() == OSType.MAC;
    }

    public static boolean isAndroid() {
        return osInfo.type() == OSType.ANDROID;
    }

    public static boolean isLinux() {
        return osInfo.type() == OSType.LINUX;
    }

    public static boolean isWindows() {
        return osInfo.type() == OSType.WINDOWS;
    }
}

