/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.function.CallableX;
import cool.scx.function.RunnableX;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ExceptionUtils {
    public static <T> T ignore(CallableX<T, ?> handler) {
        try {
            return (T)handler.call();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T ignore(CallableX<T, ?> handler, T defaultVal) {
        try {
            return (T)handler.call();
        }
        catch (Throwable throwable) {
            return defaultVal;
        }
    }

    public static void ignore(RunnableX<?> handler) {
        try {
            handler.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean noException(RunnableX<?> scxRunnable) {
        try {
            scxRunnable.run();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }
}

