/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.function.Function0;
import cool.scx.function.Function0Void;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ExceptionUtils {
    public static <T> T ignore(Function0<T, ?> handler) {
        try {
            return (T)handler.apply();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T ignore(Function0<T, ?> handler, T defaultVal) {
        try {
            return (T)handler.apply();
        }
        catch (Throwable throwable) {
            return defaultVal;
        }
    }

    public static void ignore(Function0Void<?> handler) {
        try {
            handler.apply();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean noException(Function0Void<?> scxRunnable) {
        try {
            scxRunnable.apply();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }
}

