/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.constant.CharPools;
import cool.scx.common.util.RandomUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public final class StopWatch {
    private static final long MILLI_SCALE = 1000000L;
    private static final double SECOND_SCALE = 1.0E9;
    private static final Map<String, Long> START_TIME_MAP = new HashMap<String, Long>();

    public static void start(String name) {
        if (START_TIME_MAP.get(name) != null) {
            throw new IllegalArgumentException("\u5b9a\u65f6\u5668 [ " + name + " ] \u5df2\u5b58\u5728!!! \u82e5\u8981\u91cd\u7f6e\u5b9a\u65f6\u5668,\u8bf7\u4f7f\u7528 reset() !!!");
        }
        START_TIME_MAP.put(name, System.nanoTime());
    }

    public static String start() {
        String randomName = RandomUtils.randomString(6, CharPools.NUMBER);
        StopWatch.start(randomName);
        return randomName;
    }

    public static void reset(String name) {
        START_TIME_MAP.put(name, System.nanoTime());
    }

    public static long stopToNanos(String name) {
        Long startTime = START_TIME_MAP.get(name);
        return startTime != null ? System.nanoTime() - startTime : -1L;
    }

    public static long stopToMillis(String name) {
        return StopWatch.nanosToMillis(StopWatch.stopToNanos(name));
    }

    public static double stopToSeconds(String name) {
        return StopWatch.nanosToSeconds(StopWatch.stopToNanos(name));
    }

    private static long nanosToMillis(long duration) {
        return duration / 1000000L;
    }

    private static double nanosToSeconds(long duration) {
        return BigDecimal.valueOf((double)duration / 1.0E9).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }
}

