/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config;

import cool.scx.config.ScxConfigSource;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.config.handler_impl.ConvertValueHandler;
import cool.scx.config.handler_impl.DefaultValueHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ScxConfig {
    private final Map<String, Object> configMapping = new LinkedHashMap<String, Object>();

    public ScxConfig(ScxConfigSource ... scxConfigSources) {
        for (ScxConfigSource scxConfigSource : scxConfigSources) {
            this.configMapping.putAll(scxConfigSource.getConfigMapping());
        }
    }

    public Object get(String keyPath) {
        return this.configMapping.get(keyPath);
    }

    public <T> T get(String keyPath, ScxConfigValueHandler<T> handler) {
        return handler.handle(keyPath, this.get(keyPath));
    }

    public <T> T getOrDefault(String keyPath, T defaultVal) {
        return this.get(keyPath, DefaultValueHandler.of(defaultVal));
    }

    public <T> T get(String keyPath, Class<T> type) {
        return this.get(keyPath, ConvertValueHandler.of(type));
    }

    public Map<String, Object> configMapping() {
        return new HashMap<String, Object>(this.configMapping);
    }
}

