/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config;

import cool.scx.util.ClassUtils;
import java.nio.file.Path;

public final class ScxEnvironment {
    private final Path appRootPath;
    private final Path tempPath;

    public ScxEnvironment(Class<?> mainClass) {
        this.appRootPath = ScxEnvironment.initAppRoot(mainClass);
        this.tempPath = this.getPathByAppRoot("AppRoot:_temp");
    }

    private static Path initAppRoot(Class<?> mainClass) {
        try {
            Path classSourcePath = Path.of(ClassUtils.getClassSource(mainClass));
            return ClassUtils.isJar((Path)classSourcePath) ? classSourcePath.getParent() : classSourcePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Path getPathByAppRoot(String path) {
        if (path.startsWith("AppRoot:")) {
            return Path.of(this.appRootPath.toString(), path.substring("AppRoot:".length()));
        }
        return Path.of(path, new String[0]);
    }

    public Path getTempPath() {
        return this.tempPath;
    }

    public Path getTempPath(String ... paths) {
        return Path.of(this.tempPath.toString(), paths);
    }
}

