/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config.source_impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.config.ScxConfigSource;
import cool.scx.util.ObjectUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonFileConfigSource
implements ScxConfigSource {
    private final LinkedHashMap<String, Object> configMapping = new LinkedHashMap();

    private JsonFileConfigSource(Path jsonPath) {
        if (jsonPath == null) {
            throw new IllegalArgumentException("jsonPath \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        try {
            if (Files.notExists(jsonPath, new LinkOption[0])) {
                throw new JsonConfigFileMissingException();
            }
            Map rawMap = (Map)ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readValue(jsonPath.toFile(), ObjectUtils.MAP_TYPE);
            this.configMapping.putAll(ObjectUtils.flatMap((Map)rawMap));
            Ansi.out().brightBlue((Object)("Y \u5df2\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6 : " + jsonPath), new AnsiElement[0]).println();
        }
        catch (Exception e) {
            if (e instanceof JsonConfigFileMissingException) {
                Ansi.out().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5df2\u4e22\u5931!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u5b58\u5728 : " + jsonPath), new AnsiElement[0]).println();
            }
            if (e instanceof JsonProcessingException) {
                Ansi.out().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5df2\u635f\u574f!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u6b63\u786e : " + jsonPath), new AnsiElement[0]).println();
            }
            e.printStackTrace();
        }
    }

    public static JsonFileConfigSource of(Path jsonPath) {
        return new JsonFileConfigSource(jsonPath);
    }

    @Override
    public Map<String, Object> getConfigMapping() {
        return this.configMapping;
    }

    private static class JsonConfigFileMissingException
    extends Exception {
        private JsonConfigFileMissingException() {
        }
    }
}

