/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config.source;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.scx.common.ansi.Ansi;
import cool.scx.common.ansi.AnsiElement;
import cool.scx.common.util.ObjectUtils;
import cool.scx.config.ScxConfigSource;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public final class JsonFileConfigSource
implements ScxConfigSource {
    private final ObjectNode configMapping = JsonNodeFactory.instance.objectNode();

    private JsonFileConfigSource(Path jsonPath) {
        if (jsonPath == null) {
            throw new IllegalArgumentException("jsonPath \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        try {
            if (Files.notExists(jsonPath, new LinkOption[0])) {
                throw new JsonConfigFileMissingException();
            }
            JsonNode rawMap = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readTree(jsonPath.toFile());
            if (!(rawMap instanceof ObjectNode)) {
                throw new JsonConfigFileNotObjectException();
            }
            ObjectNode objectNode = (ObjectNode)rawMap;
            this.configMapping.setAll(objectNode);
            Ansi.ansi().brightBlue((Object)("Y \u5df2\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6 : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
        }
        catch (Exception e) {
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonConfigFileMissingException.class, JsonProcessingException.class, JsonConfigFileNotObjectException.class}, (Object)exception2, n)) {
                case 0: {
                    JsonConfigFileMissingException jsonConfigFileMissingException = (JsonConfigFileMissingException)exception2;
                    Ansi.ansi().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5df2\u4e22\u5931!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u5b58\u5728 : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                    break;
                }
                case 1: {
                    JsonProcessingException jsonProcessingException = (JsonProcessingException)exception2;
                    Ansi.ansi().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5df2\u635f\u574f!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u6b63\u786e : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                    break;
                }
                case 2: {
                    JsonConfigFileNotObjectException jsonConfigFileNotObjectException = (JsonConfigFileNotObjectException)exception2;
                    Ansi.ansi().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5fc5\u987b\u4e3a Object \u683c\u5f0f!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u6b63\u786e : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                    break;
                }
                default: {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JsonFileConfigSource of(Path jsonPath) {
        return new JsonFileConfigSource(jsonPath);
    }

    @Override
    public ObjectNode configMapping() {
        return this.configMapping;
    }

    private static class JsonConfigFileMissingException
    extends Exception {
        private JsonConfigFileMissingException() {
        }
    }

    private static class JsonConfigFileNotObjectException
    extends Exception {
        private JsonConfigFileNotObjectException() {
        }
    }
}

