/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config.source;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.scx.common.util.JsonNodeHelper;
import cool.scx.config.ScxConfigSource;
import cool.scx.config.source.AbstractConfigSource;

public class MultiConfigSource
extends AbstractConfigSource {
    private final ScxConfigSource[] sources;

    public MultiConfigSource(ScxConfigSource ... sources) {
        this.sources = sources;
        this.configMapping = MultiConfigSource.loadFromSources(sources);
        this.bindOnChange(sources);
    }

    public static ObjectNode loadFromSources(ScxConfigSource ... sources) {
        ObjectNode configMapping = JsonNodeFactory.instance.objectNode();
        for (ScxConfigSource scxConfigSource : sources) {
            JsonNodeHelper.merge((ObjectNode)configMapping, (ObjectNode)scxConfigSource.configMapping());
        }
        return configMapping;
    }

    public void bindOnChange(ScxConfigSource ... sources) {
        for (ScxConfigSource source : sources) {
            source.onChange(this::callOnChange0);
        }
    }

    private void callOnChange0(ObjectNode oldValue, ObjectNode newValue) {
        ObjectNode oldConfigMapping = this.configMapping;
        this.configMapping = MultiConfigSource.loadFromSources(this.sources);
        this.callOnChange(oldConfigMapping, this.configMapping);
    }
}

