/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config.handler;

import cool.scx.ansi.Ansi;
import cool.scx.ansi.AnsiElement;
import cool.scx.config.CryptoUtils;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.object.ScxObject;
import cool.scx.object.node.Node;

public final class DecryptValueHandler
implements ScxConfigValueHandler<String> {
    private final String password;

    private DecryptValueHandler(String password) {
        this.password = password;
    }

    public static DecryptValueHandler of(String password) {
        return new DecryptValueHandler(password);
    }

    @Override
    public String handle(String keyPath, Node rawValue) {
        String str = (String)ScxObject.convertValue((Object)rawValue, String.class);
        if (str != null) {
            try {
                return str.startsWith("DECRYPT:") ? CryptoUtils.decryptText(str.substring("DECRYPT:".length()), this.password) : str;
            }
            catch (Exception e) {
                Ansi.ansi().red((Object)("N \u89e3\u5bc6 " + keyPath + " \u51fa\u9519 !!!"), new AnsiElement[0]).println();
            }
        }
        return null;
    }
}

