/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config.source;

import cool.scx.ansi.Ansi;
import cool.scx.ansi.AnsiElement;
import cool.scx.config.source.AbstractConfigSource;
import cool.scx.io.file.FileWatcher;
import cool.scx.object.ScxObject;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.parser.NodeParseException;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public final class JsonFileConfigSource
extends AbstractConfigSource {
    private final Path jsonPath;
    private FileWatcher fileWatcher;

    private JsonFileConfigSource(Path jsonPath) {
        this.jsonPath = jsonPath;
        this.configMapping = JsonFileConfigSource.loadFromJsonFile(jsonPath);
        this.bindOnChange(this.jsonPath);
    }

    public static ObjectNode loadFromJsonFile(Path jsonPath) {
        if (jsonPath == null) {
            throw new IllegalArgumentException("jsonPath \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        try {
            if (Files.notExists(jsonPath, new LinkOption[0])) {
                throw new JsonConfigFileMissingException();
            }
            Node rawMap = ScxObject.fromJson((File)jsonPath.toFile());
            if (rawMap instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)rawMap;
                Ansi.ansi().brightBlue((Object)("Y \u5df2\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6 : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                return objectNode;
            }
            throw new JsonConfigFileNotObjectException();
        }
        catch (Exception e) {
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonConfigFileMissingException.class, NodeParseException.class, JsonConfigFileNotObjectException.class}, (Exception)exception2, n)) {
                case 0: {
                    Ansi.ansi().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5df2\u4e22\u5931!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u5b58\u5728 : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                    break;
                }
                case 1: {
                    Ansi.ansi().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5df2\u635f\u574f!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u6b63\u786e : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                    break;
                }
                case 2: {
                    Ansi.ansi().red((Object)("N \u914d\u7f6e\u6587\u4ef6\u5fc5\u987b\u4e3a Object \u683c\u5f0f!!! \u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u6b63\u786e : " + String.valueOf(jsonPath)), new AnsiElement[0]).println();
                    break;
                }
                default: {
                    e.printStackTrace();
                }
            }
            return new ObjectNode();
        }
    }

    public static JsonFileConfigSource of(Path jsonPath) {
        return new JsonFileConfigSource(jsonPath);
    }

    public void bindOnChange(Path jsonPath) {
        try {
            this.fileWatcher = new FileWatcher(jsonPath).listener(this::onJsonFileChange).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void onJsonFileChange(FileWatcher.ChangeEvent changeEvent) {
        ObjectNode oldConfigMapping = this.configMapping;
        this.configMapping = JsonFileConfigSource.loadFromJsonFile(this.jsonPath);
        this.callOnChange(oldConfigMapping, this.configMapping);
    }

    private static class JsonConfigFileMissingException
    extends Exception {
        private JsonConfigFileMissingException() {
        }
    }

    private static class JsonConfigFileNotObjectException
    extends Exception {
        private JsonConfigFileNotObjectException() {
        }
    }
}

