/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.config.source;

import cool.scx.config.ScxConfigSource;
import cool.scx.config.source.AbstractConfigSource;
import cool.scx.object.NodeHelper;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;

public class MultiConfigSource
extends AbstractConfigSource {
    private final ScxConfigSource[] sources;

    public MultiConfigSource(ScxConfigSource ... sources) {
        this.sources = sources;
        this.configMapping = MultiConfigSource.loadFromSources(sources);
        this.bindOnChange(sources);
    }

    public static ObjectNode loadFromSources(ScxConfigSource ... sources) {
        ObjectNode configMapping = new ObjectNode();
        for (ScxConfigSource scxConfigSource : sources) {
            NodeHelper.merge((Node)configMapping, (Node)scxConfigSource.configMapping());
        }
        return configMapping;
    }

    public void bindOnChange(ScxConfigSource ... sources) {
        for (ScxConfigSource source : sources) {
            source.onChange(this::callOnChange0);
        }
    }

    private void callOnChange0(ObjectNode oldValue, ObjectNode newValue) {
        ObjectNode oldConfigMapping = this.configMapping;
        this.configMapping = MultiConfigSource.loadFromSources(this.sources);
        this.callOnChange(oldConfigMapping, this.configMapping);
    }
}

