/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.config.ScxConfig;
import cool.scx.config.ScxConfigSource;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.core.ScxBeanFactory;
import cool.scx.core.ScxBuilder;
import cool.scx.core.ScxContext;
import cool.scx.core.ScxCoreConfig;
import cool.scx.core.ScxHelper;
import cool.scx.core.ScxLoggerConfiguration;
import cool.scx.core.ScxModule;
import cool.scx.core.ScxTemplate;
import cool.scx.core.dao.ScxDao;
import cool.scx.core.enumeration.ScxCoreFeature;
import cool.scx.core.eventbus.MessageCodecRegistrar;
import cool.scx.core.http.ScxHttpRouter;
import cool.scx.core.mvc.ScxMappingConfiguration;
import cool.scx.core.mvc.ScxMappingRegistrar;
import cool.scx.core.scheduler.ScxScheduler;
import cool.scx.core.websocket.ScxWebSocketMappingRegistrar;
import cool.scx.core.websocket.ScxWebSocketRouter;
import cool.scx.util.ConsoleUtils;
import cool.scx.util.NetUtils;
import cool.scx.util.StopWatch;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import java.net.BindException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;

public final class Scx {
    private final ScxEnvironment scxEnvironment;
    private final String appKey;
    private final ScxFeatureConfig scxFeatureConfig;
    private final ScxConfig scxConfig;
    private final ScxModule[] scxModules;
    private final ScxCoreConfig scxCoreConfig;
    private final Vertx vertx;
    private final ScxBeanFactory scxBeanFactory;
    private final ScxTemplate scxTemplate;
    private final ScxDao scxDao;
    private final ScxMappingConfiguration scxMappingConfiguration;
    private final ScxScheduler scxScheduler;
    private ScxHttpRouter scxHttpRouter = null;
    private ScxWebSocketRouter scxWebSocketRouter = null;
    private HttpServer vertxHttpServer = null;

    Scx(ScxEnvironment scxEnvironment, String appKey, ScxFeatureConfig scxFeatureConfig, ScxConfigSource[] scxConfigSources, ScxModule[] scxModules) {
        ScxContext.scx(this);
        this.scxEnvironment = scxEnvironment;
        this.appKey = appKey;
        this.scxFeatureConfig = scxFeatureConfig;
        this.scxConfig = new ScxConfig(scxConfigSources);
        this.scxModules = Scx.initScxModuleMetadataList(scxModules);
        this.scxCoreConfig = new ScxCoreConfig(this.scxConfig, this.scxEnvironment, this.appKey);
        ScxLoggerConfiguration.init(this.scxConfig, this.scxEnvironment);
        this.vertx = Scx.initVertx();
        MessageCodecRegistrar.registerCodec(this.vertx.eventBus());
        this.scxBeanFactory = Scx.initScxBeanFactory(this.scxModules, (ScheduledExecutorService)this.vertx.nettyEventLoopGroup(), this.scxFeatureConfig);
        this.scxTemplate = new ScxTemplate(this.scxCoreConfig);
        this.scxDao = new ScxDao(this.scxCoreConfig);
        this.scxMappingConfiguration = new ScxMappingConfiguration();
        this.scxScheduler = new ScxScheduler(this.vertx.nettyEventLoopGroup());
    }

    static void printBanner() {
        Ansi.out().red((Object)"   \u2584\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 ", new AnsiElement[0]).green((Object)" \u2584\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 ", new AnsiElement[0]).blue((Object)"\u2580\u2588\u2588\u2588\u2588    \u2590\u2588\u2588\u2588\u2588\u2580 ", new AnsiElement[0]).ln().red((Object)"  \u2588\u2588\u2588    \u2588\u2588\u2588 ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588    \u2588\u2588\u2588 ", new AnsiElement[0]).blue((Object)"  \u2588\u2588\u2588\u258c   \u2588\u2588\u2588\u2588\u2580  ", new AnsiElement[0]).ln().red((Object)"  \u2588\u2588\u2588    \u2588\u2580  ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588    \u2588\u2580  ", new AnsiElement[0]).blue((Object)"   \u2588\u2588\u2588  \u2590\u2588\u2588\u2588    ", new AnsiElement[0]).ln().red((Object)"  \u2588\u2588\u2588        ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588        ", new AnsiElement[0]).blue((Object)"   \u2580\u2588\u2588\u2588\u2584\u2588\u2588\u2588\u2580    ", new AnsiElement[0]).ln().red((Object)"\u2580\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588        ", new AnsiElement[0]).blue((Object)"   \u2588\u2588\u2588\u2588\u2580\u2588\u2588\u2584     ", new AnsiElement[0]).ln().red((Object)"         \u2588\u2588\u2588 ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588    \u2588\u2584  ", new AnsiElement[0]).blue((Object)"  \u2590\u2588\u2588\u2588  \u2580\u2588\u2588\u2588    ", new AnsiElement[0]).ln().red((Object)"   \u2584\u2588    \u2588\u2588\u2588 ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588    \u2588\u2588\u2588 ", new AnsiElement[0]).blue((Object)" \u2584\u2588\u2588\u2588     \u2588\u2588\u2588\u2584  ", new AnsiElement[0]).ln().red((Object)" \u2584\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2580  ", new AnsiElement[0]).green((Object)"\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2580  ", new AnsiElement[0]).blue((Object)"\u2588\u2588\u2588\u2588       \u2588\u2588\u2588\u2584 ", new AnsiElement[0]).cyan((Object)" Version ", new AnsiElement[0]).brightCyan((Object)"1.19.1", new AnsiElement[0]).println();
    }

    public static ScxBuilder builder() {
        return new ScxBuilder();
    }

    private static boolean isUseNewPort(int port) {
        String result;
        do {
            String errMessage = "*******************************************************\n*                                                     *\n*         \u7aef\u53e3\u53f7 [ %s ] \u5df2\u88ab\u5360\u7528, \u662f\u5426\u91c7\u7528\u65b0\u7aef\u53e3\u53f7 ?       *\n*                                                     *\n*                [Y]es    |    [N]o                   *\n*                                                     *\n*******************************************************\n";
            System.err.printf(errMessage + System.lineSeparator(), port);
            result = ConsoleUtils.readLine().trim();
            if (!"Y".equalsIgnoreCase(result)) continue;
            return true;
        } while (!"N".equalsIgnoreCase(result));
        String ignoreMessage = "*******************************************\n*                                         *\n*     N \u7aef\u53e3\u53f7\u88ab\u5360\u7528!!! \u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25 !!!      *\n*                                         *\n*******************************************\n";
        System.err.println(ignoreMessage);
        System.exit(-1);
        return false;
    }

    private static ScxBeanFactory initScxBeanFactory(ScxModule[] modules, ScheduledExecutorService scheduledExecutorService, ScxFeatureConfig scxFeatureConfig) {
        Class[] beanClass = (Class[])Arrays.stream(modules).flatMap(c -> c.classList().stream()).filter(ScxHelper::isBeanClass).toArray(Class[]::new);
        return new ScxBeanFactory(scheduledExecutorService, scxFeatureConfig).registerBeanDefinition(beanClass);
    }

    private static Vertx initVertx() {
        VertxOptions vertxOptions = new VertxOptions();
        return Vertx.vertx((VertxOptions)vertxOptions);
    }

    private static ScxModule[] initScxModuleMetadataList(ScxModule[] scxModules) {
        if (scxModules == null || Arrays.stream(scxModules).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("Modules must not be empty !!!");
        }
        return scxModules;
    }

    private void startAllScxModules() {
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) {
            for (ScxModule m : this.scxModules) {
                Ansi.out().brightWhite((Object)"[", new AnsiElement[0]).brightGreen((Object)"Starting", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
                m.start();
                Ansi.out().brightWhite((Object)"[", new AnsiElement[0]).brightGreen((Object)"Start OK", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
            }
        } else {
            for (ScxModule m : this.scxModules) {
                m.start();
            }
        }
    }

    private void stopAllScxModules() {
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) {
            for (ScxModule m : this.scxModules) {
                Ansi.out().brightWhite((Object)"[", new AnsiElement[0]).brightRed((Object)"Stopping", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
                m.stop();
                Ansi.out().brightWhite((Object)"[", new AnsiElement[0]).brightRed((Object)"Stop  OK", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
            }
        } else {
            for (ScxModule m : this.scxModules) {
                m.stop();
            }
        }
    }

    public void run() {
        StopWatch.start((String)"ScxRun");
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_BANNER)).booleanValue()) {
            Scx.printBanner();
        }
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_CORE_CONFIG_INFO)).booleanValue()) {
            this.scxCoreConfig.showCoreConfigInfo();
        }
        this.scxHttpRouter = new ScxHttpRouter(this);
        this.scxWebSocketRouter = new ScxWebSocketRouter();
        new ScxMappingRegistrar(this).registerRoute(this.scxHttpRouter.vertxRouter());
        new ScxWebSocketMappingRegistrar(this).registerRoute(this.scxWebSocketRouter);
        this.startAllScxModules();
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_START_UP_INFO)).booleanValue()) {
            Ansi.out().brightYellow((Object)("\u5df2\u52a0\u8f7d " + this.scxBeanFactory.getBeanDefinitionNames().length + " \u4e2a Bean !!!"), new AnsiElement[0]).ln().brightGreen((Object)("\u5df2\u52a0\u8f7d " + this.scxHttpRouter.vertxRouter().getRoutes().size() + " \u4e2a Http \u8def\u7531 !!!"), new AnsiElement[0]).ln().brightBlue((Object)("\u5df2\u52a0\u8f7d " + this.scxWebSocketRouter.getRoutes().size() + " \u4e2a WebSocket \u8def\u7531 !!!"), new AnsiElement[0]).println();
        }
        HttpServerOptions httpServerOptions = new HttpServerOptions();
        if (this.scxCoreConfig.isHttpsEnabled()) {
            httpServerOptions.setSsl(true).setKeyStoreOptions(new JksOptions().setPath(this.scxCoreConfig.sslPath().toString()).setPassword(this.scxCoreConfig.sslPassword()));
        }
        this.vertxHttpServer = this.vertx.createHttpServer(httpServerOptions);
        this.vertxHttpServer.requestHandler((Handler)this.scxHttpRouter.vertxRouter()).webSocketHandler((Handler)this.scxWebSocketRouter);
        this.addShutdownHook();
        this.startServer(this.scxCoreConfig.port());
        this.scxBeanFactory.refresh();
    }

    private void startServer(int port) {
        this.vertxHttpServer.listen(port, http -> {
            if (http.succeeded()) {
                String[] normalIP;
                String httpOrHttps = this.scxCoreConfig.isHttpsEnabled() ? "https" : "http";
                Ansi o = Ansi.out().green((Object)("\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f... \u7528\u65f6 " + StopWatch.stopToMillis((String)"ScxRun") + " ms"), new AnsiElement[0]).ln();
                for (String ip : normalIP = NetUtils.getLocalIPAddress().getNormalIP()) {
                    o.green((Object)("> \u7f51\u7edc: " + httpOrHttps + "://" + ip + ":" + this.vertxHttpServer.actualPort() + "/"), new AnsiElement[0]).ln();
                }
                o.green((Object)("> \u672c\u5730: " + httpOrHttps + "://localhost:" + this.vertxHttpServer.actualPort() + "/"), new AnsiElement[0]).println();
            } else {
                Throwable cause = http.cause();
                if (cause instanceof BindException) {
                    if (Scx.isUseNewPort(port)) {
                        this.startServer(0);
                    }
                } else {
                    cause.printStackTrace();
                }
            }
        });
    }

    public ScxEnvironment scxEnvironment() {
        return this.scxEnvironment;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public String appKey() {
        return this.appKey;
    }

    public ScxModule[] scxModules() {
        return Arrays.copyOf(this.scxModules, this.scxModules.length);
    }

    public <T extends ScxModule> T findScxModule(Class<T> clazz) {
        for (ScxModule m : this.scxModules) {
            if (m.getClass() != clazz) continue;
            return (T)m;
        }
        return null;
    }

    public ScxCoreConfig scxCoreConfig() {
        return this.scxCoreConfig;
    }

    public ScxBeanFactory scxBeanFactory() {
        return this.scxBeanFactory;
    }

    public ScxHttpRouter scxHttpRouter() {
        return this.scxHttpRouter;
    }

    public ScxTemplate scxTemplate() {
        return this.scxTemplate;
    }

    public ScxConfig scxConfig() {
        return this.scxConfig;
    }

    public ScxFeatureConfig scxFeatureConfig() {
        return this.scxFeatureConfig;
    }

    public ScxDao scxDao() {
        return this.scxDao;
    }

    public HttpServer vertxHttpServer() {
        return this.vertxHttpServer;
    }

    public EventBus eventBus() {
        return this.vertx.eventBus();
    }

    public ScxWebSocketRouter scxWebSocketRouter() {
        return this.scxWebSocketRouter;
    }

    public ScxMappingConfiguration scxMappingConfiguration() {
        return this.scxMappingConfiguration;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stopAllScxModules();
            Ansi.out().red((Object)"\u9879\u76ee\u6b63\u5728\u505c\u6b62!!!", new AnsiElement[0]).println();
        }));
    }

    public ScxScheduler scxScheduler() {
        return this.scxScheduler;
    }
}

