/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.core.annotation.ScxComponent;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.annotation.ScxModel;
import cool.scx.core.annotation.ScxService;
import cool.scx.core.annotation.ScxWebSocketMapping;
import cool.scx.core.base.BaseModel;
import cool.scx.util.ClassUtils;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public final class ScxHelper {
    private static final List<Class<? extends Annotation>> beanFilterAnnotation = List.of(ScxComponent.class, ScxMapping.class, ScxModel.class, ScxService.class, ScxWebSocketMapping.class, Component.class, Controller.class, Service.class, Repository.class);

    public static boolean isBeanClass(Class<?> clazz) {
        for (Class<? extends Annotation> a : beanFilterAnnotation) {
            if (clazz.getAnnotation(a) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isScxBaseModelClass(Class<?> c) {
        return c.isAnnotationPresent(ScxModel.class) && ClassUtils.isInstantiableClass(c) && BaseModel.class.isAssignableFrom(c);
    }

    public static boolean isScxBaseModelServiceClass(Class<?> c) {
        ParameterizedType t;
        Type type;
        return c.isAnnotationPresent(ScxService.class) && ClassUtils.isNormalClass(c) && (type = c.getGenericSuperclass()) instanceof ParameterizedType && (t = (ParameterizedType)type).getActualTypeArguments().length == 1;
    }

    public static boolean responseCanUse(RoutingContext context) {
        return !context.request().response().ended() && !context.request().response().closed();
    }
}

