/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.mvc;

import cool.scx.core.Scx;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.mvc.ScxMappingHandler;
import cool.scx.util.ClassUtils;
import cool.scx.util.MultiMap;
import cool.scx.util.ObjectUtils;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.impl.RouteImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

public final class ScxMappingRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(ScxMappingRegistrar.class);
    private static final Method vertxRouteStateMethod = ScxMappingRegistrar.initVertxRouteStateMethod();
    private static final Comparator<ScxMappingHandler> exactPathComparator = Comparator.comparing(routeState -> routeState.routeState().getExactPathOrder());
    private static final Comparator<ScxMappingHandler> groupsComparator = Comparator.comparing(routeState -> routeState.routeState().getGroupsOrder());
    private static final Comparator<ScxMappingHandler> orderComparator = Comparator.comparing(ScxMappingHandler::order);
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":(\\w+)");
    private final List<ScxMappingHandler> scxMappingHandlers;

    public ScxMappingRegistrar(Scx scx) {
        this.scxMappingHandlers = ScxMappingRegistrar.initScxMappingHandlers(scx);
    }

    private static Method initVertxRouteStateMethod() {
        try {
            Method m = RouteImpl.class.getDeclaredMethod("state", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static RouteState getRouteState(Route r) {
        try {
            return (RouteState)ObjectUtils.convertValue((Object)vertxRouteStateMethod.invoke((Object)r, new Object[0]), RouteState.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ScxMappingHandler> sortedScxMappingHandlers(List<ScxMappingHandler> scxMappingHandlers) {
        return scxMappingHandlers.stream().sorted(orderComparator.thenComparing(exactPathComparator).thenComparing(groupsComparator)).toList();
    }

    private static List<ScxMappingHandler> fillRouteState(List<ScxMappingHandler> list, Scx scx) {
        Router tempRouter = Router.router((Vertx)scx.vertx());
        return list.stream().peek(c -> c.setRouteState(ScxMappingRegistrar.getRouteState(tempRouter.route(c.originalUrl)))).toList();
    }

    private static List<ScxMappingHandler> initScxMappingHandlers(Scx scx) {
        List<Class> scxMappingClassList = Arrays.stream(scx.scxModules()).flatMap(c -> c.classList().stream()).filter(ScxMappingRegistrar::isScxMappingClass).toList();
        List<ScxMappingHandler> allScxMappingHandlers = scxMappingClassList.stream().flatMap(c -> Arrays.stream(c.getMethods()).filter(ScxMappingRegistrar::isScxMappingMethod).map(m -> new ScxMappingHandler((Class<?>)c, (Method)m, scx))).toList();
        List<ScxMappingHandler> filledList = ScxMappingRegistrar.fillRouteState(allScxMappingHandlers, scx);
        return ScxMappingRegistrar.sortedScxMappingHandlers(filledList);
    }

    public static boolean isScxMappingClass(Class<?> c) {
        return (c.isAnnotationPresent(ScxMapping.class) || c.isAnnotationPresent(Controller.class)) && ClassUtils.isNormalClass(c);
    }

    public static boolean isScxMappingMethod(Method m) {
        return m.isAnnotationPresent(ScxMapping.class) && !m.isBridge();
    }

    private static void checkScxMappingHandlerRouteExists(List<ScxMappingHandler> scxMappingHandlers) {
        MultiMap m = new MultiMap();
        for (ScxMappingHandler scxMappingHandler : scxMappingHandlers) {
            String key = scxMappingHandler.routeState().pattern() != null ? scxMappingHandler.routeState().pattern().toString() : scxMappingHandler.routeState().path();
            for (cool.scx.core.enumeration.HttpMethod httpMethod : scxMappingHandler.httpMethods) {
                m.put((Object)new NormalPathInfo(httpMethod, key), (Object)scxMappingHandler);
            }
        }
        Map map = m.asMap();
        map.forEach((k, v) -> {
            if (v.size() > 1) {
                String content = v.stream().map(c -> "\t" + c.clazz.getName() + " : " + c.method.getName()).collect(Collectors.joining(System.lineSeparator()));
                logger.error("\u68c0\u6d4b\u5230\u91cd\u590d\u7684\u8def\u7531!!! {} --> \"{}\" , \u76f8\u5173 class \u53ca \u65b9\u6cd5 \u5982\u4e0b \u25bc" + System.lineSeparator() + "{}", new Object[]{k.httpMethod, ScxMappingRegistrar.getPatternUrl(((ScxMappingHandler)v.get((int)0)).originalUrl), content});
            }
        });
    }

    private static String getPatternUrl(String path) {
        return RE_TOKEN_SEARCH.matcher(path).replaceAll("?");
    }

    public List<ScxMappingHandler> scxMappingHandlers() {
        return new ArrayList<ScxMappingHandler>(this.scxMappingHandlers);
    }

    public void registerRoute(Router router) {
        ScxMappingRegistrar.checkScxMappingHandlerRouteExists(this.scxMappingHandlers);
        for (ScxMappingHandler c : this.scxMappingHandlers) {
            Route r = router.route(c.originalUrl);
            for (cool.scx.core.enumeration.HttpMethod httpMethod : c.httpMethods) {
                r.method(httpMethod.vertxMethod());
            }
            r.handler((Handler)c);
        }
    }

    record RouteState(Map<String, Object> metadata, String path, String name, int order, boolean enabled, Set<HttpMethod> methods, Set<MIMEHeader> consumes, boolean emptyBodyPermittedWithConsumes, Set<MIMEHeader> produces, boolean added, Pattern pattern, List<String> groups, boolean useNormalizedPath, Set<String> namedGroupsInRegex, Pattern virtualHostPattern, boolean pathEndsWithSlash, boolean exclusive, boolean exactPath) {
        int getGroupsOrder() {
            return this.groups == null ? 0 : this.groups.size();
        }

        int getExactPathOrder() {
            return this.exactPath ? 0 : 1;
        }
    }

    record NormalPathInfo(cool.scx.core.enumeration.HttpMethod httpMethod, String key) {
    }
}

