/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.scheduler;

import cool.scx.core.scheduler.ScheduleStatus;
import cool.scx.functional.ScxHandlerA;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

class CounterRunnable
implements Runnable {
    final AtomicLong runCount = new AtomicLong(1L);
    final ScxHandlerA<ScheduleStatus> scxHandler;
    ScheduledFuture<?> scheduledFuture = null;

    public CounterRunnable(ScxHandlerA<ScheduleStatus> scxHandler) {
        this.scxHandler = scxHandler;
    }

    @Override
    public void run() {
        this.scxHandler.handle((Object)new ScheduleStatus(this.runCount.getAndIncrement(), this.scheduledFuture));
    }

    public ScheduledFuture<?> schedule(TaskScheduler executor, Trigger trigger) {
        this.scheduledFuture = executor.schedule((Runnable)this, trigger);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(TaskScheduler executor, Instant startTime, Duration delay) {
        this.scheduledFuture = executor.scheduleWithFixedDelay((Runnable)this, startTime, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(TaskScheduler executor, Instant startTime, Duration delay) {
        this.scheduledFuture = executor.scheduleAtFixedRate((Runnable)this, startTime, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(TaskScheduler executor, Duration delay) {
        this.scheduledFuture = executor.scheduleWithFixedDelay((Runnable)this, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(TaskScheduler executor, Duration delay) {
        this.scheduledFuture = executor.scheduleAtFixedRate((Runnable)this, delay);
        return this.scheduledFuture;
    }
}

