/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.websocket;

import cool.scx.core.Scx;
import cool.scx.core.annotation.ScxWebSocketMapping;
import cool.scx.core.base.BaseWebSocketHandler;
import cool.scx.core.websocket.ScxWebSocketRoute;
import cool.scx.core.websocket.ScxWebSocketRouter;
import cool.scx.util.ClassUtils;
import cool.scx.util.URIBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ScxWebSocketMappingRegistrar {
    private static final Comparator<ScxWebSocketRoute> orderComparator = Comparator.comparing(ScxWebSocketRoute::order);
    private final List<ScxWebSocketRoute> scxWebSocketRoutes;

    public ScxWebSocketMappingRegistrar(Scx scx) {
        this.scxWebSocketRoutes = ScxWebSocketMappingRegistrar.initScxWebSocketRoutes(scx);
    }

    private static List<ScxWebSocketRoute> initScxWebSocketRoutes(Scx scx) {
        List<Class> scxWebSocketRouteClassList = Arrays.stream(scx.scxModules()).flatMap(c -> c.classList().stream()).filter(ScxWebSocketMappingRegistrar::isScxWebSocketRouteClass).map(c -> c).toList();
        List<ScxWebSocketRoute> list = scxWebSocketRouteClassList.stream().map(c -> {
            ScxWebSocketMapping scxWebSocketMapping = c.getAnnotation(ScxWebSocketMapping.class);
            String path = URIBuilder.addSlashStart((String)URIBuilder.join((String[])new String[]{scxWebSocketMapping.value()}));
            int order = scxWebSocketMapping.order();
            BaseWebSocketHandler baseWebSocketHandler = (BaseWebSocketHandler)scx.scxBeanFactory().getBean(c);
            return new ScxWebSocketRoute(order, path, baseWebSocketHandler);
        }).toList();
        return ScxWebSocketMappingRegistrar.sortedScxWebSocketRoutes(list);
    }

    public static boolean isScxWebSocketRouteClass(Class<?> c) {
        return c.isAnnotationPresent(ScxWebSocketMapping.class) && ClassUtils.isNormalClass(c) && BaseWebSocketHandler.class.isAssignableFrom(c);
    }

    private static List<ScxWebSocketRoute> sortedScxWebSocketRoutes(List<ScxWebSocketRoute> list) {
        return list.stream().sorted(orderComparator).toList();
    }

    public void registerRoute(ScxWebSocketRouter scxWebSocketRouter) {
        for (ScxWebSocketRoute route : this.scxWebSocketRoutes) {
            scxWebSocketRouter.addRoute(route);
        }
    }
}

