/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.config.ScxConfig;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.core.Scx;
import cool.scx.core.ScxHttpRouter;
import cool.scx.core.ScxModule;
import cool.scx.core.ScxOptions;
import cool.scx.core.enumeration.ScxCoreFeature;
import cool.scx.core.scheduler.ScxScheduler;
import cool.scx.functional.ScxRunnable;
import cool.scx.mvc.ScxMvc;
import cool.scx.mvc.websocket.ScxWebSocketRouter;
import cool.scx.sql.SQLRunner;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServer;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;

public final class ScxContext {
    private static Scx GLOBAL_SCX = null;

    static void scx(Scx scx) {
        GLOBAL_SCX = scx;
    }

    public static Scx scx() {
        if (GLOBAL_SCX != null) {
            return GLOBAL_SCX;
        }
        throw new RuntimeException("\u5168\u5c40 Scx \u672a\u521d\u59cb\u5316 !!! \u8bf7\u5148\u4f7f\u7528 Scx.builder() \u521b\u5efa Scx \u5b9e\u4f8b , \u5168\u5c40 Scx \u4f1a\u81ea\u52a8\u8bbe\u7f6e !!!");
    }

    public static ScxFeatureConfig featureConfig() {
        return ScxContext.scx().scxFeatureConfig();
    }

    public static ScxConfig config() {
        return ScxContext.scx().scxConfig();
    }

    public static DataSource dataSource() {
        return ScxContext.scx().dataSource();
    }

    public static HttpServer httpServer() {
        return ScxContext.scx().vertxHttpServer();
    }

    public static EventBus eventBus() {
        return ScxContext.scx().eventBus();
    }

    public static ScxWebSocketRouter webSocketRouter() {
        return ScxContext.scx().scxWebSocketRouter();
    }

    public static ScxEnvironment environment() {
        return ScxContext.scx().scxEnvironment();
    }

    public static String appKey() {
        return ScxContext.scx().appKey();
    }

    public static ScxModule[] scxModules() {
        return ScxContext.scx().scxModules();
    }

    public static ScxOptions options() {
        return ScxContext.scx().scxOptions();
    }

    public static BeanFactory beanFactory() {
        return ScxContext.scx().beanFactory();
    }

    public static ScxHttpRouter router() {
        return ScxContext.scx().scxHttpRouter();
    }

    public static Vertx vertx() {
        return ScxContext.scx().vertx();
    }

    public static ScxScheduler scheduler() {
        return ScxContext.scx().scxScheduler();
    }

    public static ScxMvc scxMvc() {
        return ScxContext.scx().scxMvc();
    }

    public static boolean getFeatureState(ScxCoreFeature scxFeature) {
        return (Boolean)ScxContext.featureConfig().get((ScxFeature)scxFeature);
    }

    public static SQLRunner sqlRunner() {
        return ScxContext.scx().sqlRunner();
    }

    public static void autoTransaction(ScxRunnable<?> handler) {
        ScxContext.sqlRunner().autoTransaction(handler);
    }

    public static <T> T autoTransaction(Callable<T> handler) {
        return (T)ScxContext.sqlRunner().autoTransaction(handler);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)ScxContext.beanFactory().getBean(requiredType);
    }

    public static <T extends ScxModule> T findScxModule(Class<T> clazz) {
        return ScxContext.scx().findScxModule(clazz);
    }

    public static Path getPathByAppRoot(String path) {
        return ScxContext.environment().getPathByAppRoot(path);
    }

    public static Path getTempPath() {
        return ScxContext.environment().getTempPath();
    }

    public static Path getTempPath(String ... paths) {
        return ScxContext.environment().getTempPath(paths);
    }
}

