/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.core.enumeration.ScxCoreFeature;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor;

public final class ScxBeanFactory {
    private final DefaultListableBeanFactory springBeanFactory = new DefaultListableBeanFactory();

    public ScxBeanFactory(ScheduledExecutorService scheduledExecutorService, ScxFeatureConfig scxFeatureConfig) {
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setBeanFactory((BeanFactory)this.springBeanFactory);
        this.springBeanFactory.addBeanPostProcessor((BeanPostProcessor)beanPostProcessor);
        if (((Boolean)scxFeatureConfig.get((ScxFeature)ScxCoreFeature.ENABLE_SCHEDULING_WITH_ANNOTATION)).booleanValue()) {
            ScheduledAnnotationBeanPostProcessor scheduledAnnotationBeanPostProcessor = new ScheduledAnnotationBeanPostProcessor();
            scheduledAnnotationBeanPostProcessor.setBeanFactory((BeanFactory)this.springBeanFactory);
            scheduledAnnotationBeanPostProcessor.setScheduler((Object)scheduledExecutorService);
            scheduledAnnotationBeanPostProcessor.afterSingletonsInstantiated();
            this.springBeanFactory.addBeanPostProcessor((BeanPostProcessor)scheduledAnnotationBeanPostProcessor);
        }
        this.springBeanFactory.setAllowCircularReferences(((Boolean)scxFeatureConfig.get((ScxFeature)ScxCoreFeature.ALLOW_CIRCULAR_REFERENCES)).booleanValue());
    }

    void refresh() {
        this.springBeanFactory.preInstantiateSingletons();
    }

    public <T> T getBean(Class<T> requiredType) {
        return (T)this.springBeanFactory.getBean(requiredType);
    }

    public ScxBeanFactory registerBeanDefinition(Class<?> ... classList) {
        for (Class<?> c : classList) {
            AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(c);
            AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)beanDefinition);
            this.springBeanFactory.registerBeanDefinition(c.getName(), (BeanDefinition)beanDefinition);
        }
        return this;
    }

    public void removeBeanDefinition(String beanName) {
        this.springBeanFactory.removeBeanDefinition(beanName);
    }

    public String[] getBeanDefinitionNames() {
        return this.springBeanFactory.getBeanDefinitionNames();
    }
}

