/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.dao;

import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.jdbc.MysqlDataSource;
import com.zaxxer.hikari.HikariDataSource;
import cool.scx.core.ScxCoreConfig;
import cool.scx.sql.SQLRunner;
import cool.scx.util.ConsoleUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScxDao {
    private static final Logger logger = LoggerFactory.getLogger(ScxDao.class);
    private final DataSource dataSource;
    private final SQLRunner sqlRunner;

    public ScxDao(ScxCoreConfig coreConfig) {
        MysqlDataSource mysqlDataSource = ScxDao.getMySQLDataSource(coreConfig);
        this.dataSource = ScxDao.getHikariDataSource(mysqlDataSource);
        this.sqlRunner = new SQLRunner(this.dataSource);
    }

    private static DataSource getHikariDataSource(MysqlDataSource mysqlDataSource) {
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setDataSource((DataSource)mysqlDataSource);
        return hikariDataSource;
    }

    private static MysqlDataSource getMySQLDataSource(ScxCoreConfig scxCoreConfig) {
        MysqlDataSource mysqlDataSource = new MysqlDataSource();
        mysqlDataSource.setServerName(scxCoreConfig.dataSourceHost());
        mysqlDataSource.setDatabaseName(scxCoreConfig.dataSourceDatabase());
        mysqlDataSource.setUser(scxCoreConfig.dataSourceUsername());
        mysqlDataSource.setPassword(scxCoreConfig.dataSourcePassword());
        mysqlDataSource.setPort(scxCoreConfig.dataSourcePort());
        for (String parameter : scxCoreConfig.dataSourceParameters()) {
            String[] p = parameter.split("=");
            if (p.length != 2) continue;
            RuntimeProperty property = mysqlDataSource.getProperty(p[0]);
            property.setValue(property.getPropertyDefinition().parseObject(p[1], null));
        }
        return mysqlDataSource;
    }

    public static void dataSourceExceptionHandler(Exception e) {
        block1: {
            String result;
            do {
                String errMessage = "**************************************************************\n*                                                            *\n*           X \u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25 !!! \u662f\u5426\u5ffd\u7565\u9519\u8bef\u5e76\u7ee7\u7eed\u8fd0\u884c ?            *\n*                                                            *\n*        [Y] \u5ffd\u7565\u9519\u8bef\u5e76\u7ee7\u7eed\u8fd0\u884c    |     [N] \u9000\u51fa\u7a0b\u5e8f              *\n*                                                            *\n**************************************************************\n";
                System.err.println(errMessage);
                result = ConsoleUtils.readLine().trim();
                if (!"Y".equalsIgnoreCase(result)) continue;
                String ignoreMessage = "*******************************************\n*                                         *\n*       N \u6570\u636e\u6e90\u94fe\u63a5\u9519\u8bef,\u7528\u6237\u5df2\u5ffd\u7565 !!!         *\n*                                         *\n*******************************************\n";
                System.err.println(ignoreMessage);
                break block1;
            } while (!"N".equalsIgnoreCase(result));
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public boolean checkDataSource() {
        boolean bl;
        block8: {
            Connection conn = this.dataSource().getConnection();
            try {
                DatabaseMetaData dm = conn.getMetaData();
                logger.debug("\u6570\u636e\u6e90\u8fde\u63a5\u6210\u529f : \u7c7b\u578b [{}]  \u7248\u672c [{}]", (Object)dm.getDatabaseProductName(), (Object)dm.getDatabaseProductVersion());
                bl = true;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ScxDao.dataSourceExceptionHandler(e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public SQLRunner sqlRunner() {
        return this.sqlRunner;
    }
}

