/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.dao;

import cool.scx.core.ScxContext;
import cool.scx.core.ScxHelper;
import cool.scx.core.dao.ScxDaoColumnInfo;
import cool.scx.core.dao.ScxDaoTableInfo;
import cool.scx.sql.SQL;
import cool.scx.sql.SQLRunner;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScxDaoHelper {
    private static final Logger logger = LoggerFactory.getLogger(ScxDaoHelper.class);

    public static void fixTable() {
        logger.debug("\u4fee\u590d\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        int fixSuccess = 0;
        int fixFail = 0;
        int noNeedToFix = 0;
        for (Class<?> v : ScxDaoHelper.getAllScxBaseModelClassList()) {
            ScxDaoTableInfo tableInfo = new ScxDaoTableInfo(v);
            try {
                if (ScxDaoHelper.checkNeedFixTable0(tableInfo)) {
                    ScxDaoHelper.fixTable0(tableInfo);
                    ++fixSuccess;
                    continue;
                }
                ++noNeedToFix;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++fixFail;
            }
        }
        if (fixSuccess != 0) {
            logger.debug("\u4fee\u590d\u6210\u529f {} \u5f20\u8868...", (Object)fixSuccess);
        }
        if (fixFail != 0) {
            logger.warn("\u4fee\u590d\u5931\u8d25 {} \u5f20\u8868...", (Object)fixFail);
        }
        if (fixSuccess + fixFail == 0) {
            logger.debug("\u6ca1\u6709\u8868\u9700\u8981\u4fee\u590d...");
        }
    }

    private static List<Class<?>> getAllScxBaseModelClassList() {
        return Arrays.stream(ScxContext.scxModules()).flatMap(c -> c.classList().stream()).filter(ScxHelper::isScxBaseModelClass).toList();
    }

    public static boolean checkNeedFixTable() {
        logger.debug("\u68c0\u67e5\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        for (Class<?> v : ScxDaoHelper.getAllScxBaseModelClassList()) {
            ScxDaoTableInfo tableInfo = new ScxDaoTableInfo(v);
            try {
                if (!ScxDaoHelper.checkNeedFixTable0(tableInfo)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void fixTable0(ScxDaoTableInfo tableInfo) throws SQLException {
        String databaseName = ScxContext.coreConfig().dataSourceDatabase();
        try (Connection con = ScxContext.dao().dataSource().getConnection();){
            List<String> existingColumn = ScxDaoHelper.getTableAllColumnNames(con, databaseName, tableInfo.tableName());
            if (existingColumn != null) {
                List<ScxDaoColumnInfo> nonExistentColumnNames = Stream.of(tableInfo.columnInfos()).filter(c -> !existingColumn.contains(c.columnName())).toList();
                if (nonExistentColumnNames.size() > 0) {
                    String alertTableDDL = tableInfo.getAlertTableDDL(nonExistentColumnNames);
                    SQLRunner.execute((Connection)con, (SQL)SQL.ofNormal((String)alertTableDDL));
                }
            } else {
                SQLRunner.execute((Connection)con, (SQL)SQL.ofNormal((String)tableInfo.getCreateTableDDL()));
            }
        }
    }

    private static boolean checkNeedFixTable0(ScxDaoTableInfo tableInfo) throws SQLException {
        String databaseName = ScxContext.coreConfig().dataSourceDatabase();
        try (Connection con = ScxContext.dao().dataSource().getConnection();){
            List<String> existingColumn = ScxDaoHelper.getTableAllColumnNames(con, databaseName, tableInfo.tableName());
            if (existingColumn != null) {
                List<ScxDaoColumnInfo> nonExistentColumnNames = Stream.of(tableInfo.columnInfos()).filter(c -> !existingColumn.contains(c.columnName())).toList();
                boolean bl = nonExistentColumnNames.size() != 0;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static List<String> getTableAllColumnNames(Connection con, String databaseName, String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = con.getMetaData();
        ResultSet nowTable = dbMetaData.getTables(databaseName, databaseName, tableName, new String[]{"TABLE"});
        if (nowTable.next()) {
            ResultSet nowColumns = dbMetaData.getColumns(databaseName, databaseName, nowTable.getString("TABLE_NAME"), null);
            ArrayList<String> existingColumn = new ArrayList<String>();
            while (nowColumns.next()) {
                existingColumn.add(nowColumns.getString("COLUMN_NAME"));
            }
            return existingColumn;
        }
        return null;
    }
}

