/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.http;

import cool.scx.core.Scx;
import cool.scx.core.http.ScxHttpException;
import cool.scx.core.http.ScxHttpHelper;
import cool.scx.core.http.ScxHttpResponseStatus;
import cool.scx.core.http.ScxHttpRouterExceptionHandler;
import cool.scx.core.http.exception.InternalServerErrorException;
import cool.scx.core.http.exception_handler.LastExceptionHandler;
import cool.scx.core.http.exception_handler.ScxHttpExceptionHandler;
import cool.scx.util.ScxExceptionHelper;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.ArrayList;
import java.util.List;

public final class ScxHttpRouter {
    private final Router vertxRouter;
    private final CorsHandler corsHandler;
    private final BodyHandler bodyHandler;
    private final Route corsHandlerRoute;
    private final Route bodyHandlerRoute;
    private final List<ScxHttpRouterExceptionHandler> scxHttpRouterExceptionHandlers = new ArrayList<ScxHttpRouterExceptionHandler>();

    public ScxHttpRouter(Scx scx) {
        this.addExceptionHandler(ScxHttpExceptionHandler.DEFAULT_INSTANCE);
        this.vertxRouter = Router.router((Vertx)scx.vertx());
        this.bindErrorHandler(this.vertxRouter);
        this.corsHandler = ScxHttpHelper.initCorsHandler(scx.scxCoreConfig().allowedOrigin());
        this.bodyHandler = ScxHttpHelper.initBodyHandler(scx.scxEnvironment().getTempPath(new String[]{"file-uploads"}));
        this.corsHandlerRoute = this.vertxRouter.route().handler((Handler)this.corsHandler);
        this.bodyHandlerRoute = this.vertxRouter.route().handler((Handler)this.bodyHandler);
    }

    private void bindErrorHandler(Router vertxRouter) {
        ErrorHandler errorHandler = new ErrorHandler(this);
        for (ScxHttpResponseStatus s : ScxHttpResponseStatus.values()) {
            vertxRouter.errorHandler(s.statusCode(), (Handler)errorHandler);
        }
    }

    public Router vertxRouter() {
        return this.vertxRouter;
    }

    public CorsHandler corsHandler() {
        return this.corsHandler;
    }

    public BodyHandler bodyHandler() {
        return this.bodyHandler;
    }

    public Route corsHandlerRoute() {
        return this.corsHandlerRoute;
    }

    public Route bodyHandlerRoute() {
        return this.bodyHandlerRoute;
    }

    public ScxHttpRouter addExceptionHandler(ScxHttpRouterExceptionHandler scxHttpRouterExceptionHandler) {
        this.scxHttpRouterExceptionHandlers.add(scxHttpRouterExceptionHandler);
        return this;
    }

    public ScxHttpRouter addExceptionHandler(int index, ScxHttpRouterExceptionHandler scxHttpRouterExceptionHandler) {
        this.scxHttpRouterExceptionHandlers.add(index, scxHttpRouterExceptionHandler);
        return this;
    }

    public ScxHttpRouterExceptionHandler findExceptionHandler(Throwable throwable) {
        for (ScxHttpRouterExceptionHandler handler : this.scxHttpRouterExceptionHandlers) {
            if (!handler.canHandle(throwable)) continue;
            return handler;
        }
        return LastExceptionHandler.DEFAULT_INSTANCE;
    }

    private record ErrorHandler(ScxHttpRouter scxHttpRouter) implements Handler<RoutingContext>
    {
        public void handle(RoutingContext routingContext) {
            Throwable routingContextException = ScxExceptionHelper.getRootCause((Throwable)routingContext.failure());
            int routingContextStatusCode = routingContext.statusCode();
            if (routingContextStatusCode == 500) {
                this.scxHttpRouter.findExceptionHandler(routingContextException).handle(routingContextException, routingContext);
            } else {
                ScxHttpResponseStatus byStatusCode = ScxHttpResponseStatus.findByStatusCode(routingContextStatusCode);
                ScxHttpException scxHttpException = byStatusCode != null ? new ScxHttpException(byStatusCode.statusCode(), byStatusCode.reasonPhrase(), routingContextException) : new InternalServerErrorException(routingContextException);
                this.scxHttpRouter.findExceptionHandler(scxHttpException).handle(scxHttpException, routingContext);
            }
        }
    }
}

