/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.mvc;

import cool.scx.core.Scx;
import cool.scx.core.ScxContext;
import cool.scx.core.ScxHelper;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.enumeration.HttpMethod;
import cool.scx.core.mvc.ScxMappingRegistrar;
import cool.scx.util.CaseUtils;
import cool.scx.util.ScxExceptionHelper;
import cool.scx.util.URIBuilder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.stream.Stream;

public final class ScxMappingHandler
implements Handler<RoutingContext> {
    public final Method method;
    public final boolean isVoid;
    public final Parameter[] parameters;
    public final Object example;
    public final Class<?> clazz;
    public final String originalUrl;
    public final HttpMethod[] httpMethods;
    private final Scx scx;
    private final int order;
    private ScxMappingRegistrar.RouteState routeState;

    public ScxMappingHandler(Class<?> clazz, Method method, Scx scx) {
        this.scx = scx;
        this.clazz = clazz;
        this.method = method;
        this.method.setAccessible(true);
        this.isVoid = method.getReturnType().equals(Void.TYPE);
        this.parameters = method.getParameters();
        this.example = this.scx.scxBeanFactory().getBean(clazz);
        ScxMapping classScxMapping = clazz.getAnnotation(ScxMapping.class);
        ScxMapping methodScxMapping = method.getAnnotation(ScxMapping.class);
        this.originalUrl = this.initOriginalUrl(classScxMapping, methodScxMapping);
        this.httpMethods = ScxMappingHandler.initHttpMethod(methodScxMapping);
        this.order = methodScxMapping.order();
    }

    private static HttpMethod[] initHttpMethod(ScxMapping methodScxMapping) {
        return (HttpMethod[])Stream.of(methodScxMapping.method()).distinct().toArray(HttpMethod[]::new);
    }

    private String initOriginalUrl(ScxMapping classScxMapping, ScxMapping methodScxMapping) {
        String[] urlArray = new String[]{"", ""};
        if (!methodScxMapping.ignoreParentUrl() && classScxMapping != null) {
            urlArray[0] = classScxMapping.value();
        }
        urlArray[1] = methodScxMapping.useNameAsUrl() && "".equals(methodScxMapping.value()) ? CaseUtils.toKebab((String)this.method.getName()) : methodScxMapping.value();
        return URIBuilder.addSlashStart((String)URIBuilder.join((String[])urlArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext context) {
        ScxContext._routingContext(context);
        try {
            this.scx.scxMappingConfiguration().scxMappingInterceptor().preHandle(context, this);
            Object[] methodParameters = this.scx.scxMappingConfiguration().buildMethodParameters(this.parameters, context);
            Object tempResult = this.method.invoke(this.example, methodParameters);
            Object finalResult = this.scx.scxMappingConfiguration().scxMappingInterceptor().postHandle(context, this, tempResult);
            if (!this.isVoid && ScxHelper.responseCanUse(context)) {
                this.scx.scxMappingConfiguration().findMethodReturnValueHandler(finalResult).handle(finalResult, context);
            }
        }
        catch (Throwable e) {
            Throwable exception = ScxExceptionHelper.getRootCause((Throwable)(e instanceof InvocationTargetException ? e.getCause() : e));
            this.scx.scxHttpRouter().findExceptionHandler(exception).handle(exception, context);
        }
        finally {
            ScxContext._clearRoutingContext();
        }
    }

    void setRouteState(ScxMappingRegistrar.RouteState route) {
        this.routeState = route;
    }

    ScxMappingRegistrar.RouteState routeState() {
        return this.routeState;
    }

    int order() {
        return this.order;
    }
}

