/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.scheduler;

import cool.scx.core.scheduler.CounterRunnable;
import cool.scx.core.scheduler.FixedRunCountRunnable;
import cool.scx.core.scheduler.ScheduleStatus;
import cool.scx.functional.ScxHandler;
import cool.scx.functional.ScxHandlerA;
import cool.scx.functional.ScxHandlerR;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public final class ScxScheduler {
    private final ScheduledExecutorService scheduledExecutorService;
    private final TaskScheduler taskScheduler;

    public ScxScheduler(EventLoopGroup eventLoopGroup) {
        this.scheduledExecutorService = eventLoopGroup;
        this.taskScheduler = new ConcurrentTaskScheduler(this.scheduledExecutorService);
    }

    public <R> Future<R> submit(ScxHandlerR<R> task) {
        return this.scheduledExecutorService.submit(() -> task.handle());
    }

    public Future<?> submit(ScxHandler scxHandlerV) {
        return this.scheduledExecutorService.submit(() -> ((ScxHandler)scxHandlerV).handle());
    }

    public <R> ScheduledFuture<R> schedule(ScxHandlerR<R> scxHandlerVR, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(() -> scxHandlerVR.handle(), delay, unit);
    }

    public ScheduledFuture<?> schedule(ScxHandler scxHandlerV, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(() -> ((ScxHandler)scxHandlerV).handle(), delay, unit);
    }

    public ScheduledFuture<?> schedule(ScxHandlerA<ScheduleStatus> scxHandler, Trigger trigger) {
        return new CounterRunnable(scxHandler).schedule(this.taskScheduler, trigger);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ScxHandlerA<ScheduleStatus> scxHandler, Instant startTime, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ScxHandlerA<ScheduleStatus> scxHandler, Instant startTime, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ScxHandlerA<ScheduleStatus> scxHandler, Instant startTime, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ScxHandlerA<ScheduleStatus> scxHandler, Instant startTime, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ScxHandlerA<ScheduleStatus> scxHandler, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ScxHandlerA<ScheduleStatus> scxHandler, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ScxHandlerA<ScheduleStatus> scxHandler, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ScxHandlerA<ScheduleStatus> scxHandler, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.taskScheduler, delay);
    }
}

