/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.vo;

import cool.scx.functional.ScxHandlerAE;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public interface BaseVo
extends ScxHandlerAE<RoutingContext, Exception> {
    public static HttpServerResponse fillContentType(String contentType, HttpServerResponse response) {
        if (contentType != null) {
            if (contentType.startsWith("text")) {
                return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)(contentType + ";charset=utf-8"));
            }
            return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
        }
        return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/octet-stream");
    }

    public static HttpServerResponse fillJsonContentType(HttpServerResponse response) {
        return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json;charset=utf-8");
    }

    public static HttpServerResponse fillXmlContentType(HttpServerResponse response) {
        return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/xml;charset=utf-8");
    }

    public static HttpServerResponse fillHtmlContentType(HttpServerResponse response) {
        return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html;charset=utf-8");
    }

    public static HttpServerResponse fillTextPlainContentType(HttpServerResponse response) {
        return response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain;charset=utf-8");
    }

    public static String getDownloadContentDisposition(String downloadName) {
        return "attachment;filename*=utf-8''" + URLEncoder.encode(downloadName, StandardCharsets.UTF_8).replace("+", "%20");
    }
}

