/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.util.ClassUtils;
import cool.scx.util.ScxExceptionHelper;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class ScxModule {
    protected final List<Class<?>> classList;
    protected final Path rootPath;
    protected final String defaultName = this.getClass().getSimpleName();

    public ScxModule() {
        String basePackage = this.getClass().getPackageName();
        URI classSource = (URI)ScxExceptionHelper.wrap(() -> ClassUtils.getClassSource(this.getClass()));
        Path classSourcePath = Path.of(classSource);
        if (ClassUtils.isJar((Path)classSourcePath)) {
            List list = (List)ScxExceptionHelper.wrap(() -> ClassUtils.getClassListFromJar((URI)classSource));
            this.classList = ClassUtils.filterByBasePackage((List)list, (String)basePackage);
            this.rootPath = classSourcePath.getParent();
        } else {
            List list = (List)ScxExceptionHelper.wrap(() -> ClassUtils.getClassListFromDir((Path)Path.of(classSource), (ClassLoader)this.getClass().getClassLoader()));
            this.classList = ClassUtils.filterByBasePackage((List)list, (String)basePackage);
            this.rootPath = classSourcePath;
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public String name() {
        return this.defaultName;
    }

    public final List<Class<?>> classList() {
        return new ArrayList(this.classList);
    }

    public final Path rootPath() {
        return this.rootPath;
    }
}

