/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.dao;

import cool.scx.core.annotation.Column;
import cool.scx.sql.ColumnInfo;
import cool.scx.sql.SQLHelper;
import cool.scx.util.CaseUtils;
import cool.scx.util.StringUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;

public final class ScxDaoColumnInfo
implements ColumnInfo {
    private final Field field;
    private final String columnName;
    private final String type;
    private final String normalDDL;
    private final String[] specialDDL;
    private final String updateSetSQL;
    private final String insertValuesSQL;
    private final String selectSQL;

    public ScxDaoColumnInfo(Field field) {
        this.field = field;
        Column column = field.getAnnotation(Column.class);
        this.type = ScxDaoColumnInfo.initType(field, column);
        this.columnName = ScxDaoColumnInfo.initColumnName(field, column);
        this.normalDDL = ScxDaoColumnInfo.initNormalDDL(this.columnName, this.type, column);
        this.specialDDL = ScxDaoColumnInfo.initSpecialDDL(this.columnName, column);
        this.updateSetSQL = this.columnName + " = ?";
        this.insertValuesSQL = "?";
        this.selectSQL = this.fieldName().equals(this.columnName) ? this.columnName : this.columnName + " AS " + this.fieldName();
    }

    private static String initType(Field field, Column column) {
        if (column != null && StringUtils.notBlank((String)column.type())) {
            return column.type();
        }
        return SQLHelper.getMySQLTypeCreateName(field.getType());
    }

    private static String initColumnName(Field field, Column column) {
        if (column != null && StringUtils.notBlank((String)column.columnName())) {
            return column.columnName();
        }
        return CaseUtils.toSnake((String)field.getName());
    }

    private static String initNormalDDL(String name, String type, Column column) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add("`" + name + "`");
        tempList.add(type);
        if (column != null) {
            tempList.add(column.notNull() || column.primaryKey() ? "NOT NULL" : "NULL");
            if (column.autoIncrement()) {
                tempList.add("AUTO_INCREMENT");
            }
            if (StringUtils.notBlank((String)column.defaultValue())) {
                tempList.add("DEFAULT " + column.defaultValue());
            }
            if (StringUtils.notBlank((String)column.onUpdateValue())) {
                tempList.add("ON UPDATE " + column.onUpdateValue());
            }
        } else {
            tempList.add("NULL");
        }
        return String.join((CharSequence)" ", tempList);
    }

    private static String[] initSpecialDDL(String name, Column column) {
        if (column == null) {
            return new String[0];
        }
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (column.primaryKey()) {
            list.add((CallSite)((Object)("PRIMARY KEY (`" + name + "`)")));
        }
        if (column.unique()) {
            list.add((CallSite)((Object)("UNIQUE KEY `unique_" + name + "`(`" + name + "`)")));
        }
        if (column.needIndex()) {
            list.add((CallSite)((Object)("KEY `index_" + name + "`(`" + name + "`)")));
        }
        return (String[])list.toArray(String[]::new);
    }

    public Field javaField() {
        return this.field;
    }

    public String selectSQL() {
        return this.selectSQL;
    }

    public String columnName() {
        return this.columnName;
    }

    public String updateSetSQL() {
        return this.updateSetSQL;
    }

    public String insertValuesSQL() {
        return this.insertValuesSQL;
    }

    public String normalDDL() {
        return this.normalDDL;
    }

    public String[] specialDDL() {
        return this.specialDDL;
    }

    public String type() {
        return this.type;
    }
}

