/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.mvc;

import cool.scx.core.http.exception.BadRequestException;
import cool.scx.core.mvc.ScxMappingInterceptor;
import cool.scx.core.mvc.ScxMappingMethodParameterHandler;
import cool.scx.core.mvc.ScxMappingMethodReturnValueHandler;
import cool.scx.core.mvc.ScxMappingRoutingContextInfo;
import cool.scx.core.mvc.exception.ParamConvertException;
import cool.scx.core.mvc.exception.RequiredParamEmptyException;
import cool.scx.core.mvc.interceptor.ScxMappingInterceptorImpl;
import cool.scx.core.mvc.parameter_handler.FromBodyMethodParameterHandler;
import cool.scx.core.mvc.parameter_handler.FromPathMethodParameterHandler;
import cool.scx.core.mvc.parameter_handler.FromQueryMethodParameterHandler;
import cool.scx.core.mvc.parameter_handler.LastMethodParameterHandler;
import cool.scx.core.mvc.parameter_handler.RoutingContextMethodParameterHandler;
import cool.scx.core.mvc.parameter_handler.UploadedEntityMethodParameterHandler;
import cool.scx.core.mvc.return_value_handler.BaseVoMethodReturnValueHandler;
import cool.scx.core.mvc.return_value_handler.LastMethodReturnValueHandler;
import cool.scx.core.mvc.return_value_handler.NullMethodReturnValueHandler;
import cool.scx.core.mvc.return_value_handler.StringMethodReturnValueHandler;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class ScxMappingConfiguration {
    private final List<ScxMappingMethodReturnValueHandler> scxMappingMethodReturnValueHandlers = new ArrayList<ScxMappingMethodReturnValueHandler>();
    private final List<ScxMappingMethodParameterHandler> scxMappingMethodParameterHandlers = new ArrayList<ScxMappingMethodParameterHandler>();
    private ScxMappingInterceptor scxMappingInterceptor = new ScxMappingInterceptorImpl();

    public ScxMappingConfiguration() {
        this.addMethodReturnValueHandler(NullMethodReturnValueHandler.DEFAULT_INSTANCE);
        this.addMethodReturnValueHandler(StringMethodReturnValueHandler.DEFAULT_INSTANCE);
        this.addMethodReturnValueHandler(BaseVoMethodReturnValueHandler.DEFAULT_INSTANCE);
        this.addMethodParameterHandler(RoutingContextMethodParameterHandler.DEFAULT_INSTANCE);
        this.addMethodParameterHandler(UploadedEntityMethodParameterHandler.DEFAULT_INSTANCE);
        this.addMethodParameterHandler(FromBodyMethodParameterHandler.DEFAULT_INSTANCE);
        this.addMethodParameterHandler(FromQueryMethodParameterHandler.DEFAULT_INSTANCE);
        this.addMethodParameterHandler(FromPathMethodParameterHandler.DEFAULT_INSTANCE);
    }

    public ScxMappingConfiguration setScxMappingInterceptor(ScxMappingInterceptor scxMappingInterceptor) {
        if (scxMappingInterceptor == null) {
            throw new IllegalArgumentException("ScxMappingInterceptor must not be empty !!!");
        }
        this.scxMappingInterceptor = scxMappingInterceptor;
        return this;
    }

    public ScxMappingInterceptor scxMappingInterceptor() {
        return this.scxMappingInterceptor;
    }

    public ScxMappingConfiguration addMethodParameterHandler(ScxMappingMethodParameterHandler scxMappingMethodParameterHandler) {
        this.scxMappingMethodParameterHandlers.add(scxMappingMethodParameterHandler);
        return this;
    }

    public ScxMappingConfiguration addMethodReturnValueHandler(ScxMappingMethodReturnValueHandler returnValueHandler) {
        this.scxMappingMethodReturnValueHandlers.add(returnValueHandler);
        return this;
    }

    public ScxMappingConfiguration addMethodParameterHandler(int index, ScxMappingMethodParameterHandler scxMappingMethodParameterHandler) {
        this.scxMappingMethodParameterHandlers.add(index, scxMappingMethodParameterHandler);
        return this;
    }

    public ScxMappingConfiguration addMethodReturnValueHandler(int index, ScxMappingMethodReturnValueHandler returnValueHandler) {
        this.scxMappingMethodReturnValueHandlers.add(index, returnValueHandler);
        return this;
    }

    public ScxMappingMethodReturnValueHandler findMethodReturnValueHandler(Object result) {
        for (ScxMappingMethodReturnValueHandler handler : this.scxMappingMethodReturnValueHandlers) {
            if (!handler.canHandle(result)) continue;
            return handler;
        }
        return LastMethodReturnValueHandler.DEFAULT_INSTANCE;
    }

    public ScxMappingMethodParameterHandler findMethodParameterHandler(Parameter parameter) {
        for (ScxMappingMethodParameterHandler handler : this.scxMappingMethodParameterHandlers) {
            if (!handler.canHandle(parameter)) continue;
            return handler;
        }
        return LastMethodParameterHandler.DEFAULT_INSTANCE;
    }

    public Object[] buildMethodParameters(Parameter[] parameters, RoutingContext context) throws Exception {
        ScxMappingRoutingContextInfo info = new ScxMappingRoutingContextInfo(context);
        ArrayList<Exception> exceptionArrayList = new ArrayList<Exception>();
        Object[] methodParameter = new Object[parameters.length];
        for (int i = 0; i < methodParameter.length; ++i) {
            ScxMappingMethodParameterHandler methodParameterHandler = this.findMethodParameterHandler(parameters[i]);
            try {
                methodParameter[i] = methodParameterHandler.handle(parameters[i], info);
                continue;
            }
            catch (ParamConvertException | RequiredParamEmptyException e) {
                exceptionArrayList.add(e);
            }
        }
        if (!exceptionArrayList.isEmpty()) {
            throw new BadRequestException(exceptionArrayList.stream().map(Throwable::getMessage).collect(Collectors.joining(";" + System.lineSeparator())));
        }
        return methodParameter;
    }
}

