/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.vo;

import cool.scx.core.http.exception.BadRequestException;
import cool.scx.core.http.exception.NotFoundException;
import cool.scx.core.vo.BaseVo;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RoutingContext;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.AbsoluteSize;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.geometry.Size;

public abstract class Image
implements BaseVo {
    protected Image(File _file) {
        Objects.requireNonNull(_file, "\u56fe\u7247\u6587\u4ef6\u4e0d\u80fd\u4e3a null");
        if (!_file.exists()) {
            throw new NotFoundException();
        }
    }

    public static Image of(File file) {
        return Image.of(file, null, null, null);
    }

    public static Image of(File file, Integer width, Integer height, String type) {
        String contentType = MimeMapping.getMimeTypeForFilename((String)file.getName());
        if (contentType != null && contentType.startsWith("image")) {
            if (height == null && width == null) {
                return new OriginalImage(file);
            }
            return new CroppedImage(file, width, height, type);
        }
        return new SystemIconImage(file);
    }

    public final void handle(RoutingContext context) throws BadRequestException {
        context.response().putHeader((CharSequence)HttpHeaderNames.CACHE_CONTROL, (CharSequence)"public,immutable,max-age=2628000").putHeader((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (CharSequence)"bytes");
        this.imageHandler(context);
    }

    public abstract void imageHandler(RoutingContext var1);

    private static final class OriginalImage
    extends Image {
        private final String filePath;

        public OriginalImage(File file) {
            super(file);
            this.filePath = file.getPath();
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().sendFile(this.filePath);
        }
    }

    private static final class CroppedImage
    extends Image {
        private static final Map<String, Positions> TYPE_POSITIONS_MAP = new HashMap<String, Positions>();
        private final String contentType;
        private final Buffer buffer;

        public CroppedImage(File file, Integer width, Integer height, String type) {
            super(file);
            this.contentType = MimeMapping.getMimeTypeForFilename((String)file.getName());
            this.buffer = this.getBuffer(file, width, height, type == null ? "z" : type);
        }

        private Buffer getBuffer(File file, Integer width, Integer height, String type) {
            Buffer buffer;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                BufferedImage image = Thumbnails.of((File[])new File[]{file}).scale(1.0).asBufferedImage();
                int imageHeight = image.getHeight();
                int imageWidth = image.getWidth();
                int croppedHeight = height == null || height > imageHeight || height <= 0 ? imageHeight : height;
                int croppedWidth = width == null || width > imageHeight || width <= 0 ? imageWidth : width;
                AbsoluteSize absoluteSize = new AbsoluteSize(croppedWidth, croppedHeight);
                Positions positions = TYPE_POSITIONS_MAP.get(type.toLowerCase());
                if (positions != null) {
                    Thumbnails.of((File[])new File[]{file}).sourceRegion((Position)positions, (Size)absoluteSize).size(croppedWidth, croppedHeight).keepAspectRatio(false).toOutputStream((OutputStream)out);
                } else {
                    Thumbnails.of((File[])new File[]{file}).size(croppedWidth, croppedHeight).keepAspectRatio(false).toOutputStream((OutputStream)out);
                }
                buffer = Buffer.buffer((byte[])out.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BadRequestException(e);
                }
            }
            out.close();
            return buffer;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)this.contentType).end(this.buffer);
        }

        static {
            TYPE_POSITIONS_MAP.put("top-left", Positions.TOP_LEFT);
            TYPE_POSITIONS_MAP.put("top-center", Positions.TOP_CENTER);
            TYPE_POSITIONS_MAP.put("top-right", Positions.TOP_RIGHT);
            TYPE_POSITIONS_MAP.put("center-left", Positions.CENTER_LEFT);
            TYPE_POSITIONS_MAP.put("center", Positions.CENTER);
            TYPE_POSITIONS_MAP.put("center-center", Positions.CENTER);
            TYPE_POSITIONS_MAP.put("center-right", Positions.CENTER_RIGHT);
            TYPE_POSITIONS_MAP.put("bottom-left", Positions.BOTTOM_LEFT);
            TYPE_POSITIONS_MAP.put("bottom-center", Positions.BOTTOM_CENTER);
            TYPE_POSITIONS_MAP.put("bottom-right", Positions.BOTTOM_RIGHT);
            TYPE_POSITIONS_MAP.put("tl", Positions.TOP_LEFT);
            TYPE_POSITIONS_MAP.put("tc", Positions.TOP_CENTER);
            TYPE_POSITIONS_MAP.put("tr", Positions.TOP_RIGHT);
            TYPE_POSITIONS_MAP.put("cl", Positions.CENTER_LEFT);
            TYPE_POSITIONS_MAP.put("c", Positions.CENTER);
            TYPE_POSITIONS_MAP.put("cc", Positions.CENTER);
            TYPE_POSITIONS_MAP.put("cr", Positions.CENTER_RIGHT);
            TYPE_POSITIONS_MAP.put("bl", Positions.BOTTOM_LEFT);
            TYPE_POSITIONS_MAP.put("bc", Positions.BOTTOM_CENTER);
            TYPE_POSITIONS_MAP.put("br", Positions.BOTTOM_RIGHT);
        }
    }

    private static final class SystemIconImage
    extends Image {
        private final Buffer buffer;

        public SystemIconImage(File file) {
            super(file);
            this.buffer = this.getBuffer(file);
        }

        private Buffer getBuffer(File file) {
            Buffer buffer;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                java.awt.Image image = ((ImageIcon)FileSystemView.getFileSystemView().getSystemIcon(file)).getImage();
                BufferedImage myImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D g = myImage.createGraphics();
                g.drawImage(image, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)myImage, "png", out);
                buffer = Buffer.buffer((byte[])out.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BadRequestException(e);
                }
            }
            out.close();
            return buffer;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"image/png").end(this.buffer);
        }
    }
}

