/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.http;

public enum ScxHttpResponseStatus {
    BAD_REQUEST(400, "Bad Request !!!"),
    UNAUTHORIZED(401, "Unauthorized !!!"),
    NO_PERM(403, "No Perm !!!"),
    NOT_FOUND(404, "Not Found !!!"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed !!!"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type !!!"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error !!!");

    private final int statusCode;
    private final String reasonPhrase;

    private ScxHttpResponseStatus(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public static ScxHttpResponseStatus findByStatusCode(int statusCode) {
        for (ScxHttpResponseStatus s : ScxHttpResponseStatus.values()) {
            if (statusCode != s.statusCode) continue;
            return s;
        }
        return null;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String reasonPhrase() {
        return this.reasonPhrase;
    }
}

