/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.http.exception_handler;

import cool.scx.core.ScxContext;
import cool.scx.core.ScxHelper;
import cool.scx.core.enumeration.ScxCoreFeature;
import cool.scx.core.http.ScxHttpException;
import cool.scx.core.http.ScxHttpRouterExceptionHandler;
import cool.scx.core.vo.BaseVo;
import cool.scx.util.ObjectUtils;
import cool.scx.util.ScxExceptionHelper;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.ext.web.RoutingContext;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScxHttpExceptionHandler
implements ScxHttpRouterExceptionHandler {
    public static final ScxHttpExceptionHandler DEFAULT_INSTANCE = new ScxHttpExceptionHandler();
    private static final String htmlTemplate = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>%s</title>\n</head>\n<body>\n    <h1>%s - %s</h1>\n    <hr>\n    <pre>%s</pre>\n</body>\n</html>\n";
    private static final Logger logger = LoggerFactory.getLogger(ScxHttpExceptionHandler.class);

    public static void handleScxHttpException(ScxHttpException scxHttpException, RoutingContext routingContext) {
        String info = null;
        if (ScxContext.getFeatureState(ScxCoreFeature.USE_DEVELOPMENT_ERROR_PAGE)) {
            Throwable cause = ScxExceptionHelper.getRootCause((Throwable)scxHttpException.getCause());
            info = cause == null ? scxHttpException.getMessage() : ScxExceptionHelper.getStackTraceString((Throwable)cause);
        }
        ScxHttpExceptionHandler.sendToClient(scxHttpException.statusCode(), scxHttpException.title(), info, routingContext);
    }

    public static void sendToClient(int statusCode, String title, String info, RoutingContext routingContext) {
        String accept;
        if (title == null) {
            title = "";
        }
        if (info == null) {
            info = "";
        }
        if ((accept = routingContext.request().headers().get((CharSequence)HttpHeaderNames.ACCEPT)) != null && accept.toLowerCase().contains("text/html")) {
            String htmlStr = String.format(htmlTemplate, title, statusCode, title, info);
            BaseVo.fillHtmlContentType(routingContext.request().response().setStatusCode(statusCode)).end(htmlStr);
        } else {
            LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>();
            tempMap.put("statusCode", statusCode);
            tempMap.put("title", title);
            tempMap.put("info", info);
            String jsonStr = ObjectUtils.toJson(tempMap, (String)"", (ObjectUtils.Option[])new ObjectUtils.Option[0]);
            BaseVo.fillJsonContentType(routingContext.request().response().setStatusCode(statusCode)).end(jsonStr);
        }
    }

    @Override
    public boolean canHandle(Throwable throwable) {
        return throwable instanceof ScxHttpException;
    }

    @Override
    public void handle(Throwable throwable, RoutingContext context) {
        if (ScxHelper.responseCanUse(context)) {
            ScxHttpExceptionHandler.handleScxHttpException((ScxHttpException)throwable, context);
        } else {
            logger.error("\u6355\u83b7\u5230 ScxHttpException \u5f02\u5e38 !!!, \u56e0\u4e3a\u8bf7\u6c42\u5df2\u88ab\u76f8\u5e94, \u6240\u4ee5\u9519\u8bef\u4fe1\u606f\u53ef\u80fd\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef !!!", throwable);
        }
    }
}

