/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.vo;

import cool.scx.core.ScxContext;
import cool.scx.core.vo.BaseVo;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class Html
implements BaseVo {
    private final boolean useTemplate;
    private final Template template;
    private final String htmlStr;
    private final Map<String, Object> dataMap = new HashMap<String, Object>();

    private Html(Template template, String htmlStr, boolean useTemplate) {
        this.template = template;
        this.htmlStr = htmlStr;
        this.useTemplate = useTemplate;
    }

    public static Html ofString(String htmlStr) {
        return new Html(null, htmlStr, false);
    }

    public static Html of(String templatePath) throws IOException {
        Template template = ScxContext.template().getTemplateByPath(templatePath);
        return new Html(template, null, true);
    }

    public Html add(String key, Object value) {
        this.dataMap.put(key, value);
        return this;
    }

    public void accept(RoutingContext context) throws TemplateException, IOException {
        HttpServerResponse response = BaseVo.fillHtmlContentType(context.request().response());
        if (this.useTemplate) {
            StringWriter sw = new StringWriter();
            this.template.process(this.dataMap, (Writer)sw);
            response.end(sw.toString());
        } else {
            response.end(this.htmlStr);
        }
    }
}

