/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.dao;

import cool.scx.core.annotation.NoColumn;
import cool.scx.core.annotation.ScxModel;
import cool.scx.core.dao.ScxDaoColumnInfo;
import cool.scx.sql.TableInfo;
import cool.scx.util.CaseUtils;
import cool.scx.util.StringUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public final class ScxDaoTableInfo
implements TableInfo {
    private final ScxDaoColumnInfo[] columnInfos;
    private final String tableName;

    public ScxDaoTableInfo(Class<?> clazz) {
        this.tableName = ScxDaoTableInfo.initTableName(clazz);
        this.columnInfos = ScxDaoTableInfo.initAllColumnInfos(clazz);
    }

    private static ScxDaoColumnInfo[] initAllColumnInfos(Class<?> clazz) {
        return (ScxDaoColumnInfo[])Stream.of(clazz.getFields()).filter(field -> !field.isAnnotationPresent(NoColumn.class)).map(ScxDaoColumnInfo::new).toArray(ScxDaoColumnInfo[]::new);
    }

    private static String initTableName(Class<?> clazz) {
        ScxModel scxModel = clazz.getAnnotation(ScxModel.class);
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tableName())) {
            return scxModel.tableName();
        }
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tablePrefix())) {
            return scxModel.tablePrefix() + "_" + CaseUtils.toSnake((String)clazz.getSimpleName());
        }
        return "scx_" + CaseUtils.toSnake((String)clazz.getSimpleName());
    }

    public String getCreateTableDDL() {
        ArrayList<String> createTableDDL = new ArrayList<String>();
        for (ScxDaoColumnInfo columnInfo : this.columnInfos) {
            createTableDDL.add(columnInfo.normalDDL());
        }
        for (ScxDaoColumnInfo columnInfo : this.columnInfos) {
            createTableDDL.addAll(List.of(columnInfo.specialDDL()));
        }
        return "CREATE TABLE `" + this.tableName + "` (" + String.join((CharSequence)", ", createTableDDL) + ");";
    }

    public String getAlertTableDDL(List<ScxDaoColumnInfo> nonExistentColumnName) {
        ArrayList<CallSite> alertTableDDL = new ArrayList<CallSite>();
        for (ScxDaoColumnInfo field : nonExistentColumnName) {
            alertTableDDL.add((CallSite)((Object)("ADD " + field.normalDDL())));
        }
        for (ScxDaoColumnInfo s : nonExistentColumnName) {
            for (String s1 : s.specialDDL()) {
                alertTableDDL.add((CallSite)((Object)("ADD " + s1)));
            }
        }
        return "ALTER TABLE `" + this.tableName + "` " + String.join((CharSequence)", ", alertTableDDL) + ";";
    }

    public String tableName() {
        return this.tableName;
    }

    public ScxDaoColumnInfo[] columnInfos() {
        return this.columnInfos;
    }
}

