/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.mvc.parameter_handler;

import cool.scx.core.annotation.FromUpload;
import cool.scx.core.mvc.ScxMappingMethodParameterHandler;
import cool.scx.core.mvc.ScxMappingRoutingContextInfo;
import cool.scx.core.mvc.exception.RequiredParamEmptyException;
import cool.scx.core.type.UploadedEntity;
import cool.scx.util.StringUtils;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;

public final class UploadedEntityMethodParameterHandler
implements ScxMappingMethodParameterHandler {
    public static final UploadedEntityMethodParameterHandler DEFAULT_INSTANCE = new UploadedEntityMethodParameterHandler();

    private static FileUpload findFileUploadByName(RoutingContext routingContext, String name) {
        List fileUploads = routingContext.fileUploads();
        for (FileUpload f : fileUploads) {
            if (!name.equals(f.name())) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean canHandle(Parameter parameter) {
        Type type = parameter.getParameterizedType();
        return type == UploadedEntity.class || type == FileUpload.class;
    }

    @Override
    public Object handle(Parameter parameter, ScxMappingRoutingContextInfo info) throws RequiredParamEmptyException {
        FileUpload v;
        Type javaType = parameter.getParameterizedType();
        String name = parameter.getName();
        boolean required = false;
        FromUpload fromUpload = parameter.getAnnotation(FromUpload.class);
        if (fromUpload != null) {
            if (StringUtils.notBlank((String)fromUpload.value())) {
                name = fromUpload.value();
            }
            required = fromUpload.required();
        }
        if ((v = UploadedEntityMethodParameterHandler.findFileUploadByName(info.routingContext(), name)) == null && required) {
            throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromUpload] , \u53c2\u6570\u7c7b\u578b [" + parameter.getParameterizedType().getTypeName() + "]");
        }
        return javaType == UploadedEntity.class && v != null ? new UploadedEntity(v) : v;
    }
}

