/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.handler_impl.AppRootHandler;
import cool.scx.config.handler_impl.ConvertValueHandler;
import cool.scx.config.handler_impl.DefaultValueHandler;
import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

final class ScxLoggerConfiguration {
    ScxLoggerConfiguration() {
    }

    public static void init(ScxConfig scxConfig, ScxEnvironment scxEnvironment) {
        ScxLoggerConfiguration.initDefault(scxConfig, scxEnvironment);
        ScxLoggerConfiguration.initLoggers(scxConfig, scxEnvironment);
    }

    private static void initDefault(ScxConfig scxConfig, ScxEnvironment scxEnvironment) {
        ScxLoggingLevel defaultLevel = ScxLoggingLevel.of((String)((String)scxConfig.get("scx.logging.default.level", String.class)), (ScxLoggingLevel)ScxLoggingLevel.ERROR);
        ScxLoggingType defaultType = ScxLoggingType.of((String)((String)scxConfig.get("scx.logging.default.type", String.class)), (ScxLoggingType)ScxLoggingType.CONSOLE);
        Path defaultStoredDirectory = (Path)scxConfig.get("scx.logging.default.stored-directory", (ScxConfigValueHandler)AppRootHandler.of((ScxEnvironment)scxEnvironment, (String)"AppRoot:logs"));
        Boolean defaultStackTrace = (Boolean)scxConfig.get("scx.logging.default.stack-trace", (ScxConfigValueHandler)DefaultValueHandler.of((Object)false));
        ScxLoggerFactory.setDefaultLevel((ScxLoggingLevel)defaultLevel);
        ScxLoggerFactory.setDefaultType((ScxLoggingType)defaultType);
        ScxLoggerFactory.setDefaultStoredDirectory((Path)defaultStoredDirectory);
        ScxLoggerFactory.setDefaultStackTrace((boolean)defaultStackTrace);
    }

    private static void initLoggers(ScxConfig scxConfig, ScxEnvironment scxEnvironment) {
        List loggers = (List)scxConfig.get("scx.logging.loggers", (ScxConfigValueHandler)ConvertValueHandler.of((TypeReference)new TypeReference<List<Map<String, String>>>(){}));
        if (loggers != null) {
            for (Map logger : loggers) {
                String name = (String)logger.get("name");
                if (!StringUtils.notBlank((String)name)) continue;
                ScxLoggingLevel level = ScxLoggingLevel.of((String)((String)logger.get("level")), null);
                ScxLoggingType type = ScxLoggingType.of((String)((String)logger.get("type")), null);
                Path storedDirectory = StringUtils.notBlank((String)((String)logger.get("stored-directory"))) ? scxEnvironment.getPathByAppRoot((String)logger.get("stored-directory")) : null;
                Boolean stackTrace = (Boolean)ObjectUtils.convertValue(logger.get("stack-trace"), Boolean.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
                ScxLoggerFactory.getLogger((String)name).setLevel(level).setType(type).setStoredDirectory(storedDirectory).setStackTrace(stackTrace);
            }
        }
    }
}

