/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.core.ScxContext;
import cool.scx.core.ScxOptions;
import cool.scx.core.base.BaseTemplateDirective;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScxTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ScxTemplate.class);
    private static final Version VERSION = Configuration.VERSION_2_3_31;
    private final Configuration freemarkerConfig = new Configuration(VERSION);

    public ScxTemplate(ScxOptions scxOptions) {
        DefaultObjectWrapperBuilder wrapperBuilder = new DefaultObjectWrapperBuilder(VERSION);
        wrapperBuilder.setExposeFields(true);
        this.freemarkerConfig.setObjectWrapper((ObjectWrapper)wrapperBuilder.build());
        try {
            this.freemarkerConfig.setDirectoryForTemplateLoading(scxOptions.templateRoot().toFile());
        }
        catch (Exception e) {
            logger.info("\u6a21\u677f\u76ee\u5f55\u4e0d\u5b58\u5728!!! {}", (Object)scxOptions.templateRoot().toString());
        }
        this.freemarkerConfig.setDefaultEncoding("UTF-8");
        this.freemarkerConfig.setTagSyntax(0);
    }

    public Template getTemplateByPath(String pagePath) throws IOException {
        return this.freemarkerConfig.getTemplate(pagePath + ".html");
    }

    public void addDirective(Class<? extends BaseTemplateDirective> clazz) {
        try {
            BaseTemplateDirective myDirective = ScxContext.getBean(clazz);
            logger.debug("\u5df2\u6dfb\u52a0\u81ea\u5b9a\u4e49 Freemarker \u6807\u7b7e [{}] Class -> {}", (Object)myDirective.directiveName(), (Object)clazz.getName());
            this.freemarkerConfig.setSharedVariable(myDirective.directiveName(), (TemplateModel)myDirective);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

