/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.mvc.parameter_handler;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.core.annotation.FromBody;
import cool.scx.core.mvc.ScxMappingHelper;
import cool.scx.core.mvc.ScxMappingMethodParameterHandler;
import cool.scx.core.mvc.ScxMappingRoutingContextInfo;
import cool.scx.core.mvc.exception.ParamConvertException;
import cool.scx.core.mvc.exception.RequiredParamEmptyException;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

public final class FromBodyMethodParameterHandler
implements ScxMappingMethodParameterHandler {
    public static final FromBodyMethodParameterHandler DEFAULT_INSTANCE = new FromBodyMethodParameterHandler();

    public static Object getValueFromBody(String name, boolean useAllBody, boolean required, JavaType javaType, ScxMappingRoutingContextInfo info) throws RequiredParamEmptyException, ParamConvertException {
        if (info.contentType() == ScxMappingRoutingContextInfo.ContentType.FORM) {
            return FromBodyMethodParameterHandler.fromFormAttributes(name, useAllBody, required, javaType, info);
        }
        return FromBodyMethodParameterHandler.fromBody(name, useAllBody, required, javaType, info);
    }

    private static Object fromBody(String name, boolean useAllBody, boolean required, JavaType javaType, ScxMappingRoutingContextInfo info) throws RequiredParamEmptyException, ParamConvertException {
        Object o;
        JsonNode tempValue = ScxMappingHelper.getFromJsonNode(name, info.body(), useAllBody);
        if (tempValue == null || tempValue.isNull() || tempValue.isMissingNode()) {
            if (required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
            }
            return null;
        }
        try {
            o = ScxMappingHelper.readValue(tempValue, javaType);
        }
        catch (Exception e) {
            throw new ParamConvertException("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38 !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "] , \u8be6\u7ec6\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
        }
        if (o == null && required) {
            throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
        }
        return o;
    }

    private static Object fromFormAttributes(String name, boolean useAllBody, boolean required, JavaType javaType, ScxMappingRoutingContextInfo info) throws RequiredParamEmptyException, ParamConvertException {
        Object o;
        Object tempValue = ScxMappingHelper.getFromMap(name, info.routingContext().request().formAttributes(), useAllBody, javaType);
        if (tempValue == null) {
            if (required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
            }
            return null;
        }
        try {
            o = ObjectUtils.convertValue((Object)tempValue, (JavaType)javaType, (ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE});
        }
        catch (Exception e) {
            throw new ParamConvertException("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38 !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "] , \u8be6\u7ec6\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
        }
        if (o == null && required) {
            throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
        }
        return o;
    }

    @Override
    public boolean canHandle(Parameter parameter) {
        return parameter.getAnnotation(FromBody.class) != null;
    }

    @Override
    public Object handle(Parameter parameter, ScxMappingRoutingContextInfo info) throws Exception {
        JavaType javaType = ObjectUtils.constructType((Type)parameter.getParameterizedType());
        boolean required = false;
        String name = parameter.getName();
        boolean useAllBody = false;
        FromBody fromBody = parameter.getAnnotation(FromBody.class);
        if (fromBody != null) {
            required = fromBody.required();
            if (StringUtils.notBlank((String)fromBody.value())) {
                name = fromBody.value();
            }
            useAllBody = fromBody.useAllBody();
        }
        return FromBodyMethodParameterHandler.getValueFromBody(name, useAllBody, required, javaType, info);
    }
}

