/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.vo;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.core.vo.BaseVo;
import cool.scx.core.vo.JsonBodyWrapper;
import cool.scx.util.ObjectUtils;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;

public final class Json
implements BaseVo {
    private final JsonBodyWrapper<Map<String, Object>> jsonBodyWrapper;

    private Json(String message) {
        this.jsonBodyWrapper = new JsonBodyWrapper(message, new HashMap());
    }

    public static Json ok() {
        return new Json("ok");
    }

    public static Json fail() {
        return new Json("fail");
    }

    public static Json fail(String failMessage) {
        return new Json(failMessage);
    }

    public Json put(String dataKey, Object dataVal) {
        ((Map)this.jsonBodyWrapper.data).put(dataKey, dataVal);
        return this;
    }

    public void accept(RoutingContext context) {
        BaseVo.fillJsonContentType(context.request().response()).end(this.toJson(""));
    }

    public String toJson() throws JsonProcessingException {
        return ObjectUtils.toJson(this.jsonBodyWrapper, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public String toJson(String defaultValue) {
        return ObjectUtils.toJson(this.jsonBodyWrapper, (String)defaultValue, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }
}

