/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.base;

import cool.scx.core.ScxContext;
import cool.scx.core.base.BaseModel;
import cool.scx.dao.BaseDao;
import cool.scx.dao.BaseDaoTableInfo;
import cool.scx.dao.Query;
import cool.scx.dao.SelectFilter;
import cool.scx.dao.UpdateFilter;
import cool.scx.dao.impl.AnnotationConfigTableInfo;
import cool.scx.dao.where.WhereOption;
import cool.scx.sql.SQL;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

public class BaseModelService<Entity extends BaseModel> {
    protected final BaseDao<Entity> baseDao;

    public BaseModelService() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(this.getClass().getName() + " : \u5fc5\u987b\u8bbe\u7f6e\u6cdb\u578b\u53c2\u6570 !!!");
        }
        Type[] typeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        Class entityClass = (Class)typeArguments[0];
        this.baseDao = new BaseDao((BaseDaoTableInfo)new AnnotationConfigTableInfo(entityClass), entityClass, ScxContext.sqlRunner());
    }

    public BaseModelService(Class<Entity> entityClass) {
        this.baseDao = new BaseDao((BaseDaoTableInfo)new AnnotationConfigTableInfo(entityClass), entityClass, ScxContext.sqlRunner());
    }

    private static UpdateFilter updateFilterProcessor(UpdateFilter updateFilter) {
        return (UpdateFilter)updateFilter.addExcluded(new String[]{"id", "createdDate", "updatedDate"});
    }

    public final Entity add(Entity entity) {
        return this.add(entity, UpdateFilter.ofExcluded());
    }

    public Entity add(Entity entity, UpdateFilter updateFilter) {
        Long newID = this.baseDao.insert(entity, BaseModelService.updateFilterProcessor(updateFilter));
        return newID != null ? (Entity)this.get(newID) : null;
    }

    public final List<Long> add(Collection<Entity> entityList) {
        return this.add(entityList, UpdateFilter.ofExcluded());
    }

    public List<Long> add(Collection<Entity> entityList, UpdateFilter updateFilter) {
        return this.baseDao.insertBatch(entityList, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final List<Entity> list() {
        return this.list(SelectFilter.ofExcluded());
    }

    public final List<Entity> list(SelectFilter selectFilter) {
        return this.list(new Query(), selectFilter);
    }

    public final List<Entity> list(long ... ids) {
        return this.list(ids.length == 1 ? new Query().equal("id", (Object)ids[0], new WhereOption[0]) : new Query().in("id", (Object)ids, new WhereOption[0]));
    }

    public final List<Entity> list(Query query) {
        return this.list(query, SelectFilter.ofExcluded());
    }

    public List<Entity> list(Query query, SelectFilter selectFilter) {
        return this.baseDao.select(query, selectFilter);
    }

    public final Entity get(long id) {
        return this.get(id, SelectFilter.ofExcluded());
    }

    public final Entity get(long id, SelectFilter selectFilter) {
        return this.get(new Query().equal("id", (Object)id, new WhereOption[0]), selectFilter);
    }

    public final Entity get(Query query) {
        return this.get(query, SelectFilter.ofExcluded());
    }

    public final Entity get(Query query, SelectFilter selectFilter) {
        List<Entity> list = this.list(query.setPagination(Integer.valueOf(1)), selectFilter);
        return (Entity)(list.size() > 0 ? (BaseModel)list.get(0) : null);
    }

    public final long count() {
        return this.count(new Query());
    }

    public final long count(Query query) {
        return this.baseDao.count(query);
    }

    public final Entity update(Entity entity) {
        return this.update(entity, UpdateFilter.ofExcluded());
    }

    public final Entity update(Entity entity, UpdateFilter updateFilter) {
        if (((BaseModel)entity).id == null) {
            throw new RuntimeException("\u6839\u636e id \u66f4\u65b0\u65f6 id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.update(entity, new Query().equal("id", (Object)((BaseModel)entity).id, new WhereOption[0]), updateFilter);
        return this.get(((BaseModel)entity).id);
    }

    public final long update(Entity entity, Query query) {
        return this.update(entity, query, UpdateFilter.ofExcluded());
    }

    public long update(Entity entity, Query query, UpdateFilter updateFilter) {
        return this.baseDao.update(entity, query, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final long delete(long ... ids) {
        if (ids.length == 0) {
            throw new IllegalArgumentException("\u5f85\u5220\u9664\u7684 ids \u6570\u91cf\u81f3\u5c11\u4e3a 1 \u4e2a");
        }
        return this.delete(ids.length == 1 ? new Query().equal("id", (Object)ids[0], new WhereOption[0]) : new Query().in("id", (Object)ids, new WhereOption[0]));
    }

    public long delete(Query query) {
        return this.baseDao.delete(query);
    }

    public final SQL buildListSQL(Query query, SelectFilter selectFilter) {
        return this.baseDao.buildSelectSQL(query, selectFilter);
    }

    public final SQL buildGetSQL(Query query, SelectFilter selectFilter) {
        return this.buildListSQL(query.setPagination(Integer.valueOf(1)), selectFilter);
    }

    public final SQL buildListSQLWithAlias(Query query, SelectFilter selectFilter) {
        return this.baseDao.buildSelectSQLWithAlias(query, selectFilter);
    }

    public final SQL buildGetSQLWithAlias(Query query, SelectFilter selectFilter) {
        return this.buildListSQLWithAlias(query.setPagination(Integer.valueOf(1)), selectFilter);
    }

    public BaseDao<Entity> _baseDao() {
        return this.baseDao;
    }
}

