/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.scheduler;

import cool.scx.core.scheduler.CounterRunnable;
import cool.scx.core.scheduler.FixedRunCountRunnable;
import cool.scx.core.scheduler.ScheduleStatus;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public final class ScxScheduler {
    private final ScheduledExecutorService scheduledExecutorService;
    private final TaskScheduler taskScheduler;

    public ScxScheduler(EventLoopGroup eventLoopGroup) {
        this.scheduledExecutorService = eventLoopGroup;
        this.taskScheduler = new ConcurrentTaskScheduler(this.scheduledExecutorService);
    }

    public <R> Future<R> submit(Callable<R> task) {
        return this.scheduledExecutorService.submit(task);
    }

    public Future<?> submit(Runnable runnable) {
        return this.scheduledExecutorService.submit(runnable);
    }

    public <R> ScheduledFuture<R> schedule(Callable<R> scxHandlerVR, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(scxHandlerVR, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(runnable, delay, unit);
    }

    public ScheduledFuture<?> schedule(Consumer<ScheduleStatus> scxHandler, Trigger trigger) {
        return new CounterRunnable(scxHandler).schedule(this.taskScheduler, trigger);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.taskScheduler, delay);
    }
}

