/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.base;

import cool.scx.core.ScxContext;
import cool.scx.core.base.BaseModel;
import cool.scx.data.Query;
import cool.scx.data.jdbc.ColumnFilter;
import cool.scx.data.jdbc.JDBCDao;
import cool.scx.data.jdbc.sql.SQL;
import cool.scx.data.query.WhereOption;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

public class BaseModelService<Entity extends BaseModel> {
    protected final Class<Entity> entityClass;
    private JDBCDao<Entity> dao;

    public BaseModelService() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(this.getClass().getName() + " : \u5fc5\u987b\u8bbe\u7f6e\u6cdb\u578b\u53c2\u6570 !!!");
        }
        Type[] typeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        this.entityClass = (Class)typeArguments[0];
    }

    public BaseModelService(Class<Entity> entityClass) {
        this.entityClass = entityClass;
    }

    private static ColumnFilter updateFilterProcessor(ColumnFilter updateFilter) {
        return updateFilter.addExcluded(new String[]{"id", "createdDate", "updatedDate"});
    }

    public final Entity add(Entity entity) {
        return this.add(entity, ColumnFilter.ofExcluded());
    }

    public Entity add(Entity entity, ColumnFilter updateFilter) {
        Long newID = this._dao().add(entity, BaseModelService.updateFilterProcessor(updateFilter));
        return newID != null ? (Entity)this.get(newID) : null;
    }

    public final List<Long> add(Collection<Entity> entityList) {
        return this.add(entityList, ColumnFilter.ofExcluded());
    }

    public List<Long> add(Collection<Entity> entityList, ColumnFilter updateFilter) {
        return this._dao().addAll(entityList, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final List<Entity> list() {
        return this.list(ColumnFilter.ofExcluded());
    }

    public final List<Entity> list(ColumnFilter selectFilter) {
        return this.list(new Query(), selectFilter);
    }

    public final List<Entity> list(long ... ids) {
        return this.list(ids.length == 1 ? new Query().equal("id", (Object)ids[0], new WhereOption[0]) : new Query().in("id", (Object)ids, new WhereOption[0]));
    }

    public final List<Entity> list(Query query) {
        return this.list(query, ColumnFilter.ofExcluded());
    }

    public List<Entity> list(Query query, ColumnFilter selectFilter) {
        return this._dao().find(query, selectFilter);
    }

    public final Entity get(long id) {
        return this.get(id, ColumnFilter.ofExcluded());
    }

    public final Entity get(long id, ColumnFilter selectFilter) {
        return this.get(new Query().equal("id", (Object)id, new WhereOption[0]), selectFilter);
    }

    public final Entity get(Query query) {
        return this.get(query, ColumnFilter.ofExcluded());
    }

    public final Entity get(Query query, ColumnFilter selectFilter) {
        return (Entity)((BaseModel)this._dao().get(query, selectFilter));
    }

    public final long count() {
        return this.count(new Query());
    }

    public final long count(Query query) {
        return this._dao().count(query);
    }

    public final Entity update(Entity entity) {
        return this.update(entity, ColumnFilter.ofExcluded());
    }

    public final Entity update(Entity entity, ColumnFilter updateFilter) {
        if (((BaseModel)entity).id == null) {
            throw new RuntimeException("\u6839\u636e id \u66f4\u65b0\u65f6 id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.update(entity, new Query().equal("id", (Object)((BaseModel)entity).id, new WhereOption[0]), updateFilter);
        return this.get(((BaseModel)entity).id);
    }

    public final long update(Entity entity, Query query) {
        return this.update(entity, query, ColumnFilter.ofExcluded());
    }

    public long update(Entity entity, Query query, ColumnFilter updateFilter) {
        return this._dao().update(entity, query, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final long delete(long ... ids) {
        if (ids.length == 0) {
            throw new IllegalArgumentException("\u5f85\u5220\u9664\u7684 ids \u6570\u91cf\u81f3\u5c11\u4e3a 1 \u4e2a");
        }
        return this.delete(ids.length == 1 ? new Query().equal("id", (Object)ids[0], new WhereOption[0]) : new Query().in("id", (Object)ids, new WhereOption[0]));
    }

    public long delete(Query query) {
        return this._dao().delete(query);
    }

    public final SQL buildListSQL(Query query, ColumnFilter selectFilter) {
        return this._dao().buildSelectSQL(query, selectFilter);
    }

    public final SQL buildGetSQL(Query query, ColumnFilter selectFilter) {
        return this.buildListSQL(query.setLimit(1L), selectFilter);
    }

    public final SQL buildListSQLWithAlias(Query query, ColumnFilter selectFilter) {
        return this._dao().buildSelectSQLWithAlias(query, selectFilter);
    }

    public final SQL buildGetSQLWithAlias(Query query, ColumnFilter selectFilter) {
        return this.buildListSQLWithAlias(query.setLimit(1L), selectFilter);
    }

    public final JDBCDao<Entity> _dao() {
        if (this.dao == null) {
            this.dao = new JDBCDao(this.entityClass, ScxContext.jdbcContext());
        }
        return this.dao;
    }

    public final Class<Entity> _entityClass() {
        return this.entityClass;
    }
}

